/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.vaadin.pro.licensechecker.json.impl;

import java.io.ObjectStreamException;

import com.vaadin.pro.licensechecker.json.LicenseCheckerJsonNull;
import com.vaadin.pro.licensechecker.json.LicenseCheckerJsonType;
import com.vaadin.pro.licensechecker.json.LicenseCheckerJsonValue;

/**
 * Server-side implementation of JsonObject.
 */
public class LicenseCheckerJreJsonNull extends LicenseCheckerJreJsonValue
        implements LicenseCheckerJsonNull {

    private static final long serialVersionUID = 1L;

    public static final LicenseCheckerJsonNull NULL_INSTANCE = new LicenseCheckerJreJsonNull();

    @Override
    public double asNumber() {
        return 0;
    }

    @Override
    public boolean asBoolean() {
        return false;
    }

    @Override
    public String asString() {
        return "null";
    }

    public Object getObject() {
        return null;
    }

    public LicenseCheckerJsonType getType() {
        return LicenseCheckerJsonType.NULL;
    }

    @Override
    public boolean jsEquals(LicenseCheckerJsonValue value) {
        return value == null || value.getType() == LicenseCheckerJsonType.NULL;
    }

    @Override
    public void traverse(LicenseCheckerJsonVisitor visitor,
            com.vaadin.pro.licensechecker.json.impl.LicenseCheckerJsonContext ctx) {
        visitor.visitNull(ctx);
    }

    public String toJson() {
        return "null";
    }

    private Object readResolve() throws ObjectStreamException {
        return NULL_INSTANCE;
    }
}
