/*
 * Copyright 2000-2024 Vaadin Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.vaadin.pro.licensechecker.dau;

import java.util.Collection;

import com.vaadin.pro.licensechecker.LicenseException;

/**
 * Publishes collected tracked Daily Active Users for an application to an
 * external target.
 */
@FunctionalInterface
interface Publisher {
    /**
     * Publishes collected tracked users for an application to an external
     * target.
     *
     * @param applicationName
     *            the application name
     * @param trackedUsers
     *            collection of tracked Daily Active Users.
     * @param phase
     *            DAU publishing phase that is sent to server
     * @return the enforcement rule to apply when tracking new users.
     * @throws PublishingException
     *             if an error occurs while publishing data.
     * @throws LicenseException
     *             if a license is required but not available or invalid.
     */
    DAUServerResponse publish(String applicationName,
            Collection<TrackedUser> trackedUsers, PublishingPhase phase)
            throws PublishingException, LicenseException;
}
