/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.pro.licensechecker.json.impl;

import com.vaadin.pro.licensechecker.json.LicenseCheckerJson;
import com.vaadin.pro.licensechecker.json.LicenseCheckerJsonArray;
import com.vaadin.pro.licensechecker.json.LicenseCheckerJsonBoolean;
import com.vaadin.pro.licensechecker.json.LicenseCheckerJsonFactory;
import com.vaadin.pro.licensechecker.json.LicenseCheckerJsonNumber;
import com.vaadin.pro.licensechecker.json.LicenseCheckerJsonObject;
import com.vaadin.pro.licensechecker.json.LicenseCheckerJsonString;
import com.vaadin.pro.licensechecker.json.LicenseCheckerJsonType;
import com.vaadin.pro.licensechecker.json.LicenseCheckerJsonValue;
import com.vaadin.pro.licensechecker.json.impl.LicenseCheckerJreJsonValue;
import com.vaadin.pro.licensechecker.json.impl.LicenseCheckerJsonContext;
import com.vaadin.pro.licensechecker.json.impl.LicenseCheckerJsonObjectContext;
import com.vaadin.pro.licensechecker.json.impl.LicenseCheckerJsonUtil;
import com.vaadin.pro.licensechecker.json.impl.LicenseCheckerJsonVisitor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class LicenseCheckerJreJsonObject
extends LicenseCheckerJreJsonValue
implements LicenseCheckerJsonObject {
    private static final long serialVersionUID = 1L;
    private transient LicenseCheckerJsonFactory factory;
    private transient Map<String, LicenseCheckerJsonValue> map = new LinkedHashMap<String, LicenseCheckerJsonValue>();

    private static List<String> stringifyOrder(String[] keys) {
        ArrayList<String> toReturn = new ArrayList<String>();
        ArrayList<String> nonNumeric = new ArrayList<String>();
        for (String key : keys) {
            if (key.matches("\\d+")) {
                toReturn.add(key);
                continue;
            }
            nonNumeric.add(key);
        }
        Collections.sort(toReturn);
        toReturn.addAll(nonNumeric);
        return toReturn;
    }

    public LicenseCheckerJreJsonObject(LicenseCheckerJsonFactory factory) {
        this.factory = factory;
    }

    @Override
    public boolean asBoolean() {
        return true;
    }

    @Override
    public double asNumber() {
        return Double.NaN;
    }

    @Override
    public String asString() {
        return "[object Object]";
    }

    public LicenseCheckerJsonValue get(String key) {
        return this.map.get(key);
    }

    @Override
    public LicenseCheckerJsonArray getArray(String key) {
        return (LicenseCheckerJsonArray)this.get(key);
    }

    @Override
    public boolean getBoolean(String key) {
        return ((LicenseCheckerJsonBoolean)this.get(key)).getBoolean();
    }

    @Override
    public double getNumber(String key) {
        return ((LicenseCheckerJsonNumber)this.get(key)).getNumber();
    }

    @Override
    public LicenseCheckerJsonObject getObject(String key) {
        return (LicenseCheckerJsonObject)this.get(key);
    }

    @Override
    public Object getObject() {
        HashMap<String, Object> obj = new HashMap<String, Object>();
        for (Map.Entry<String, LicenseCheckerJsonValue> e : this.map.entrySet()) {
            obj.put(e.getKey(), ((LicenseCheckerJreJsonValue)e.getValue()).getObject());
        }
        return obj;
    }

    @Override
    public String getString(String key) {
        return ((LicenseCheckerJsonString)this.get(key)).getString();
    }

    @Override
    public LicenseCheckerJsonType getType() {
        return LicenseCheckerJsonType.OBJECT;
    }

    @Override
    public boolean hasKey(String key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean jsEquals(LicenseCheckerJsonValue value) {
        return this.getObject().equals(((LicenseCheckerJreJsonValue)value).getObject());
    }

    @Override
    public String[] keys() {
        return this.map.keySet().toArray(new String[this.map.size()]);
    }

    @Override
    public void put(String key, LicenseCheckerJsonValue value) {
        if (value == null) {
            value = this.factory.createNull();
        }
        this.map.put(key, value);
    }

    @Override
    public void put(String key, String value) {
        this.put(key, this.factory.create(value));
    }

    @Override
    public void put(String key, double value) {
        this.put(key, this.factory.create(value));
    }

    @Override
    public void put(String key, boolean bool) {
        this.put(key, this.factory.create(bool));
    }

    @Override
    public void remove(String key) {
        this.map.remove(key);
    }

    public void set(String key, LicenseCheckerJsonValue value) {
        this.put(key, value);
    }

    @Override
    public String toJson() {
        return LicenseCheckerJsonUtil.stringify(this);
    }

    public String toString() {
        return this.toJson();
    }

    @Override
    public void traverse(LicenseCheckerJsonVisitor visitor, LicenseCheckerJsonContext ctx) {
        if (visitor.visit(this, ctx)) {
            LicenseCheckerJsonObjectContext objCtx = new LicenseCheckerJsonObjectContext(this);
            for (String key : LicenseCheckerJreJsonObject.stringifyOrder(this.keys())) {
                objCtx.setCurrentKey(key);
                if (!visitor.visitKey(objCtx.getCurrentKey(), objCtx)) continue;
                visitor.accept(this.get(key), objCtx);
                objCtx.setFirst(false);
            }
        }
        visitor.endVisit(this, ctx);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        LicenseCheckerJreJsonObject instance = (LicenseCheckerJreJsonObject)LicenseCheckerJreJsonObject.parseJson(stream);
        this.factory = LicenseCheckerJson.instance();
        this.map = instance.map;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.toJson());
    }
}

