/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.pro.licensechecker.dau;

import com.vaadin.pro.licensechecker.LicenseException;
import com.vaadin.pro.licensechecker.LocalSubscriptionKey;
import com.vaadin.pro.licensechecker.Util;
import com.vaadin.pro.licensechecker.dau.DAUServerResponse;
import com.vaadin.pro.licensechecker.dau.EnforcementRule;
import com.vaadin.pro.licensechecker.dau.Publisher;
import com.vaadin.pro.licensechecker.dau.PublishingException;
import com.vaadin.pro.licensechecker.dau.PublishingPhase;
import com.vaadin.pro.licensechecker.dau.TrackedUser;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonNull;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LicenseServerPublisher
implements Publisher {
    private static final Logger LOGGER = LoggerFactory.getLogger(LicenseServerPublisher.class);
    static final String DEFAULT_PUBLISHING_URL = "https://tools.vaadin.com/vaadin-license-server";
    private final String publishingUrl;

    public LicenseServerPublisher() {
        this(DEFAULT_PUBLISHING_URL);
    }

    public LicenseServerPublisher(String publishingUrl) {
        publishingUrl = Util.removeTrailingSlash(publishingUrl);
        publishingUrl = publishingUrl + "/dau/check/";
        this.publishingUrl = Util.validateURL(publishingUrl);
    }

    @Override
    public DAUServerResponse publish(String applicationName, Collection<TrackedUser> trackedUsers, PublishingPhase phase) {
        LOGGER.debug("Publishing updates for application {}", (Object)applicationName);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Tracked users: {}", trackedUsers);
        }
        JsonObject request = this.buildRequest(applicationName, trackedUsers, phase);
        try {
            JsonObject response = this.submit(request);
            DAUServerResponse dauServerResponse = this.parseResponse(response);
            LOGGER.debug("License Server enforcement policy: {}", (Object)dauServerResponse.getEnforcementRule());
            return dauServerResponse;
        }
        catch (LicenseException | PublishingException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new PublishingException("Publishing failed: " + ex.getMessage(), ex);
        }
    }

    private DAUServerResponse parseResponse(JsonObject response) {
        int status = (int)response.getNumber("status");
        response.remove("status");
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("License Server response: {}", (Object)response.toJson());
        }
        if (response.hasKey("enforce") && response.hasKey("rateLimitRemaining")) {
            try {
                List<TrackedUser> trackedUsers = this.parseTrackedUsers(response);
                return new DAUServerResponse(new EnforcementRule(response.getBoolean("enforce"), Double.valueOf(response.getNumber("rateLimitRemaining")).intValue()), trackedUsers);
            }
            catch (Exception ex) {
                throw new PublishingException("Invalid response from License Server: " + response, ex);
            }
        }
        if (response.hasKey("error") && response.hasKey("message")) {
            String errorMessage = "Error [" + response.getString("error") + "] " + response.getString("message");
            if (response.hasKey("detail")) {
                errorMessage = errorMessage + ". " + response.getString("detail");
            }
            if (response.hasKey("path")) {
                errorMessage = errorMessage + ". (Path: " + response.getString("path") + ")";
            }
            if (status == 404) {
                throw new LicenseException(errorMessage);
            }
            throw new PublishingException(errorMessage);
        }
        throw new PublishingException("Invalid response from License Server: " + response);
    }

    JsonObject buildRequest(String appIdentifier, Collection<TrackedUser> entries, PublishingPhase phase) {
        JsonObject request = Json.createObject();
        JsonArray users = Json.createArray();
        if (entries != null && !entries.isEmpty()) {
            entries.stream().flatMap(this::buildUsers).forEach(json -> users.set(users.length(), (JsonValue)json));
        }
        request.put("appName", appIdentifier);
        request.put("timestamp", Util.TIMESTAMP_FORMAT.format(Instant.now()));
        request.put("users", (JsonValue)users);
        request.put("phase", phase.name());
        return request;
    }

    private Stream<JsonObject> buildUsers(TrackedUser user) {
        Stream<String> identities = user.getUserIdentityHashes().isEmpty() ? Stream.of((String)null) : user.getUserIdentityHashes().stream();
        return identities.map(identity -> {
            JsonObject json = Json.createObject();
            json.put("trackingHash", user.getTrackingHash());
            json.put("timestamp", Util.TIMESTAMP_FORMAT.format(user.getCreationTime()));
            if (identity != null) {
                json.put("userHash", identity);
            }
            return json;
        });
    }

    private List<TrackedUser> parseTrackedUsers(JsonObject response) {
        return this.parseTrackedUsersToMap(response).values().stream().map(LicenseServerPublisher::pruneToSingleTrackedUser).collect(Collectors.toList());
    }

    private static TrackedUser pruneToSingleTrackedUser(List<TrackedUser> trackedUsers) {
        TrackedUser user = new TrackedUser(trackedUsers.get(0).getTrackingHash(), trackedUsers.stream().max(Comparator.comparing(TrackedUser::getCreationTime)).map(TrackedUser::getCreationTime).orElse(Instant.now().truncatedTo(ChronoUnit.SECONDS)));
        trackedUsers.stream().flatMap(trackedUser -> trackedUser.getUserIdentityHashes().stream()).forEach(user::linkUserIdentity);
        return user;
    }

    private Map<String, List<TrackedUser>> parseTrackedUsersToMap(JsonObject response) {
        return Optional.ofNullable(response.hasKey("users") ? response.getArray("users") : null).filter(arr -> arr.length() > 0).map(jsonArray -> IntStream.range(0, jsonArray.length()).mapToObj(arg_0 -> ((JsonArray)jsonArray).getObject(arg_0))).orElseGet(Stream::empty).map(this::parseUser).filter(Objects::nonNull).collect(Collectors.groupingBy(TrackedUser::getTrackingHash));
    }

    private TrackedUser parseUser(JsonObject user) {
        if (!user.hasKey("trackingHash")) {
            return null;
        }
        try {
            TrackedUser trackedUser = new TrackedUser(user.getString("trackingHash"), Util.TIMESTAMP_FORMAT.parse((CharSequence)user.getString("timestamp"), Instant::from));
            if (user.hasKey("userHash") && !(user.get("userHash") instanceof JsonNull)) {
                trackedUser.linkUserIdentity(user.getString("userHash"));
            }
            return trackedUser;
        }
        catch (Exception e) {
            LOGGER.warn("Failed to parse user: {}", (Object)user);
            return null;
        }
    }

    private JsonObject submit(JsonObject request) throws IOException {
        String jsonString = request.toJson();
        LOGGER.trace("Submitting DAU request: {}", (Object)jsonString);
        HttpURLConnection http = this.getHttpURLConnection();
        try (OutputStream os = http.getOutputStream();){
            os.write(jsonString.getBytes(StandardCharsets.UTF_8));
        }
        int status = http.getResponseCode();
        JsonObject response = null;
        if (status >= 200 && status < 300) {
            response = Util.parseJson(status, http.getInputStream());
        } else if (status >= 400 && status < 600) {
            response = Util.parseJson(status, http.getErrorStream());
        }
        if (response != null) {
            response.put("status", (double)status);
            return response;
        }
        throw new IOException("Unexpected response from License Server: " + status);
    }

    private HttpURLConnection getHttpURLConnection() throws IOException {
        URL url = new URL(this.publishingUrl);
        HttpURLConnection http = (HttpURLConnection)url.openConnection();
        http.setRequestMethod("POST");
        http.setRequestProperty("Content-Type", "application/json");
        http.setRequestProperty("Accept", "application/json");
        String subscriptionKey = LocalSubscriptionKey.getOrFail().getKey();
        http.setRequestProperty("Authorization", "DAU " + subscriptionKey);
        http.setConnectTimeout(5000);
        http.setReadTimeout(5000);
        http.setDoOutput(true);
        return http;
    }
}

