/*
 * Copyright 2000-2024 Vaadin Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.vaadin.pro.licensechecker;

import java.util.Optional;

import elemental.json.Json;
import elemental.json.JsonObject;

public class ProKey {
    /**
     * The username is not really needed. There was an idea early on that we
     * should construct a JWT for certain checks and that would have required
     * the username. In reality it has never been used for anything.
     */
    @Deprecated
    private String username;
    private String proKey;

    public ProKey(String username, String proKey) {
        super();
        this.username = username;
        this.proKey = proKey;
    }

    public static ProKey fromJson(String jsonData) {
        JsonObject json = Json.parse(jsonData);
        ProKey proKey = new ProKey(json.getString("username"),
                json.getString("proKey"));
        return proKey;
    }

    public String toJson() {
        JsonObject json = Json.createObject();
        json.put("username", username);
        json.put("proKey", proKey);
        return json.toJson();
    }

    public String getProKey() {
        return proKey;
    }

}
