/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.pro.licensechecker.json.impl;

import com.vaadin.pro.licensechecker.json.LicenseCheckerJsonString;
import com.vaadin.pro.licensechecker.json.LicenseCheckerJsonType;
import com.vaadin.pro.licensechecker.json.LicenseCheckerJsonValue;
import com.vaadin.pro.licensechecker.json.impl.LicenseCheckerJreJsonValue;
import com.vaadin.pro.licensechecker.json.impl.LicenseCheckerJsonContext;
import com.vaadin.pro.licensechecker.json.impl.LicenseCheckerJsonUtil;
import com.vaadin.pro.licensechecker.json.impl.LicenseCheckerJsonVisitor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class LicenseCheckerJreJsonString
extends LicenseCheckerJreJsonValue
implements LicenseCheckerJsonString {
    private static final long serialVersionUID = 1L;
    private transient String string;

    public LicenseCheckerJreJsonString(String string) {
        this.string = string;
    }

    @Override
    public boolean asBoolean() {
        return !this.getString().isEmpty();
    }

    @Override
    public double asNumber() {
        try {
            if (this.asString().isEmpty()) {
                return 0.0;
            }
            return Double.parseDouble(this.asString());
        }
        catch (NumberFormatException nfe) {
            return Double.NaN;
        }
    }

    @Override
    public String asString() {
        return this.getString();
    }

    @Override
    public Object getObject() {
        return this.getString();
    }

    @Override
    public String getString() {
        return this.string;
    }

    @Override
    public LicenseCheckerJsonType getType() {
        return LicenseCheckerJsonType.STRING;
    }

    @Override
    public boolean jsEquals(LicenseCheckerJsonValue value) {
        return this.getObject().equals(((LicenseCheckerJreJsonValue)value).getObject());
    }

    @Override
    public void traverse(LicenseCheckerJsonVisitor visitor, LicenseCheckerJsonContext ctx) {
        visitor.visit(this.getString(), ctx);
    }

    @Override
    public String toJson() throws IllegalStateException {
        return LicenseCheckerJsonUtil.quote(this.getString());
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        LicenseCheckerJreJsonString instance = (LicenseCheckerJreJsonString)LicenseCheckerJreJsonString.parseJson(stream);
        this.string = instance.string;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.toJson());
    }
}

