/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.pro.licensechecker;

import com.vaadin.pro.licensechecker.BuildType;
import com.vaadin.pro.licensechecker.LicenseChecker;
import com.vaadin.pro.licensechecker.MachineId;
import com.vaadin.pro.licensechecker.OnlineKeyValidator;
import com.vaadin.pro.licensechecker.PreTrial;
import com.vaadin.pro.licensechecker.ProKey;
import com.vaadin.pro.licensechecker.Product;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.time.Period;
import java.time.temporal.TemporalAmount;
import java.util.Base64;
import java.util.prefs.Preferences;
import org.slf4j.Logger;

public class History {
    private static final String CHECK_PREFIX = "lastcheck-";
    public static final int DEFAULT_PRE_TRIAL_DURATION_DAYS = 7;

    private static Logger getLogger() {
        return LicenseChecker.getLogger();
    }

    static boolean isRecentlyValidated(Product product, BuildType buildType, ProKey proKey) {
        return History.isRecentlyValidated(product, Period.ofDays(1), buildType, proKey);
    }

    static boolean isRecentlyValidated(Product product, TemporalAmount period, BuildType buildType, ProKey proKey) {
        History.getLogger().debug("Checking if license for {} has recently been checked for build type {} and pro key {}", new Object[]{product, buildType, proKey});
        Instant lastCheck = History.getLastCheckTime(product, buildType, proKey);
        return History.isRecentlyValidated(lastCheck, period);
    }

    private static boolean isRecentlyValidated(Instant lastCheck, TemporalAmount period) {
        if (lastCheck == null) {
            return false;
        }
        Instant now = Instant.now();
        if (lastCheck.isAfter(now)) {
            return false;
        }
        Instant nextCheck = lastCheck.plus(period);
        return now.isBefore(nextCheck);
    }

    public static Instant getLastCheckTime(Product product, BuildType buildType, ProKey proKey) {
        String lastCheckKey = History.getLastCheckKey(product, buildType, proKey);
        return History.getLastCheckTime(product, lastCheckKey);
    }

    private static Instant getLastCheckTime(Product product, String lastCheckKey) {
        long lastCheck = History.getPreferences().getLong(lastCheckKey, -1L);
        if (lastCheck == -1L) {
            History.getLogger().debug("License for {} has never been checked", (Object)product);
            return null;
        }
        Instant lastCheckInstant = Instant.ofEpochMilli(lastCheck);
        History.getLogger().debug("Last check for {} was on {}", (Object)product, (Object)lastCheckInstant);
        return lastCheckInstant;
    }

    public static String getLastSubscription(Product product, ProKey proKey) {
        String lastSubscriptionKey = History.getLastSubscriptionKey(product, proKey);
        return History.getPreferences().get(lastSubscriptionKey, "");
    }

    static long setLastCheckTimeNow(Product product, BuildType buildType, ProKey proKey) {
        History.getLogger().debug("Marking license for {} as checked now for buildType {}", (Object)product, (Object)buildType);
        return History.setLastCheck(product, Instant.now(), buildType, proKey);
    }

    static long setLastCheck(Product product, Instant instant, BuildType buildType, ProKey proKey) {
        History.getLogger().debug("Marking license for {} as checked on {} for buildType {} and pro key {}", new Object[]{product, instant, buildType, proKey});
        long timeMillis = instant.toEpochMilli();
        History.getPreferences().putLong(History.getLastCheckKey(product, buildType, proKey), timeMillis);
        return timeMillis;
    }

    public static String setLastSubscription(Product product, String subscription, ProKey proKey) {
        History.getLogger().debug("Storing subscription for {}", (Object)product);
        History.getPreferences().put(History.getLastSubscriptionKey(product, proKey), subscription);
        return subscription;
    }

    static String getLastCheckKey(Product product, BuildType buildType, ProKey proKey) {
        String key = History.getKey(product, proKey);
        if (buildType != null) {
            key = key + "-" + buildType.getKey();
        }
        return History.hash(key);
    }

    static String hash(String key) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(key.getBytes());
            byte[] digest = md.digest();
            BigInteger no = new BigInteger(1, digest);
            String hash = no.toString(16);
            while (hash.length() < 32) {
                hash = "0" + hash;
            }
            return CHECK_PREFIX + hash;
        }
        catch (NoSuchAlgorithmException e) {
            return (CHECK_PREFIX + key).substring(0, 80);
        }
    }

    private static String getKey(Product product, ProKey proKey) {
        String suffix = proKey == null ? "null" : proKey.getProKey();
        return (product != null ? product.getName() + "-" + product.getVersion() + "-" : "null-null-") + suffix;
    }

    static String getLastSubscriptionKey(Product product, ProKey proKey) {
        String key = History.getKey(product, proKey) + "-sub";
        return History.hash(key);
    }

    private static String getPreTrialKey(Product product, MachineId machineId) {
        return History.getKey(product, new ProKey(null, machineId.getPrimaryIdFull()));
    }

    static String getLastPreTrialCheckKey(Product product, MachineId machineId) {
        String key = History.getPreTrialKey(product, machineId) + "-pretrial";
        return History.hash(key);
    }

    static String getLastPreTrialPeriodKey(Product product, MachineId machineId) {
        String key = History.getPreTrialKey(product, machineId) + "-pre-trial-period";
        return History.hash(key);
    }

    static String getLastDaysRemainingUntilRenewalKey(Product product, MachineId machineId) {
        String key = History.getPreTrialKey(product, machineId) + "-pre-trial-days-remaining-until-renewal";
        return History.hash(key);
    }

    static String getLastNameKey(Product product, MachineId machineId) {
        String key = History.getPreTrialKey(product, machineId) + "-pre-trial-name";
        return History.hash(key);
    }

    static String getLastStateKey(Product product, MachineId machineId) {
        String key = History.getPreTrialKey(product, machineId) + "-pre-trial-state";
        return History.hash(key);
    }

    private static Preferences getPreferences() {
        return Preferences.userNodeForPackage(OnlineKeyValidator.class);
    }

    static long setLastPreTrialCheckTimeNow(Product product, MachineId machineId, PreTrial pretrial) {
        return History.setLastPreTrialCheckTime(product, machineId, Instant.now(), pretrial);
    }

    static long setLastPreTrialCheckTime(Product product, MachineId machineId, Instant instant, PreTrial pretrial) {
        if (pretrial.getDaysRemaining() < 0) {
            throw new IllegalArgumentException("Invalid trial period: " + pretrial.getDaysRemaining());
        }
        History.getLogger().debug("Marking pre-trial check for {} as checked on {} for machine id {}", product, instant, machineId.getPrimaryIdFull());
        long timeMillis = instant.toEpochMilli();
        History.getPreferences().putLong(History.getLastPreTrialCheckKey(product, machineId), timeMillis);
        String lastPreTrialPeriodKey = History.getLastPreTrialPeriodKey(product, machineId);
        String lastDaysRemainingUntilRenewal = History.getLastDaysRemainingUntilRenewalKey(product, machineId);
        History.getPreferences().putLong(lastPreTrialPeriodKey, (long)pretrial.getDaysRemaining() << 32);
        History.getPreferences().putLong(lastDaysRemainingUntilRenewal, (long)pretrial.getDaysRemainingUntilRenewal() << 32);
        History.getPreferences().put(History.getLastNameKey(product, machineId), Base64.getEncoder().encodeToString(pretrial.getTrialName().getBytes()));
        History.getPreferences().put(History.getLastStateKey(product, machineId), Base64.getEncoder().encodeToString(pretrial.getTrialState().name().getBytes()));
        return timeMillis;
    }

    @Deprecated
    public static Instant getLastPreTrialCheckTime(Product product, String machineId) {
        return History.getLastPreTrialCheckTime(product, new MachineId(machineId));
    }

    public static Instant getLastPreTrialCheckTime(Product product, MachineId machineId) {
        String lastCheckKey = History.getLastPreTrialCheckKey(product, machineId);
        return History.getLastCheckTime(product, lastCheckKey);
    }

    static boolean isPreTrialRecentlyValidated(Product product, MachineId machineId) {
        History.getLogger().debug("Checking if pre-trial for {} has recently been checked for machine id {}", (Object)product, (Object)machineId.getPrimaryIdFull());
        Instant lastCheck = History.getLastPreTrialCheckTime(product, machineId);
        String lastPeriodKey = History.getLastPreTrialPeriodKey(product, machineId);
        long preTrialDays = History.getPreferences().getLong(lastPeriodKey, 7L) >> 32;
        return History.isRecentlyValidated(lastCheck, Period.ofDays((int)preTrialDays));
    }

    static PreTrial getRecentlyValidatedPreTrial(Product product, MachineId machineId) {
        if (!History.isPreTrialRecentlyValidated(product, machineId)) {
            return null;
        }
        String lastNameKey = History.getLastNameKey(product, machineId);
        String lastStateKey = History.getLastStateKey(product, machineId);
        String lastPeriodKey = History.getLastPreTrialPeriodKey(product, machineId);
        String lastDaysRemainingUntilRenewalKey = History.getLastDaysRemainingUntilRenewalKey(product, machineId);
        if (History.getPreferences().get(lastStateKey, null) == null) {
            return null;
        }
        long preTrialDays = History.getPreferences().getLong(lastPeriodKey, 7L) >> 32;
        long daysRemainingUntilRenewal = History.getPreferences().getLong(lastDaysRemainingUntilRenewalKey, 30L) >> 32;
        String name = new String(Base64.getDecoder().decode(History.getPreferences().get(lastNameKey, "")));
        String state = new String(Base64.getDecoder().decode(History.getPreferences().get(lastStateKey, PreTrial.PreTrialState.START_ALLOWED.name())));
        return new PreTrial(name, PreTrial.PreTrialState.valueOf(state), (int)preTrialDays, (int)daysRemainingUntilRenewal);
    }

    public static void clearAll() throws Exception {
        Preferences preferences = History.getPreferences();
        for (String key : preferences.keys()) {
            if (!key.startsWith(CHECK_PREFIX)) continue;
            preferences.remove(key);
        }
    }
}

