/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.pro.licensechecker;

import com.vaadin.pro.licensechecker.EnvironmentVariables;
import com.vaadin.pro.licensechecker.LicenseChecker;
import com.vaadin.pro.licensechecker.LicenseException;
import com.vaadin.pro.licensechecker.LocalOfflineKey;
import com.vaadin.pro.licensechecker.LocalProKey;
import com.vaadin.pro.licensechecker.OfflineKey;
import com.vaadin.pro.licensechecker.SubscriptionKey;
import com.vaadin.pro.licensechecker.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Optional;
import org.slf4j.Logger;

public final class LocalSubscriptionKey {
    private static final String VAADIN_SUBSCRIPTION_KEY_SYSTEM_PROPERTY = "vaadin.subscriptionKey";
    private static final String VAADIN_SUBSCRIPTION_KEY_ENV_VAR = "VAADIN_SUBSCRIPTION_KEY";

    private static SubscriptionKey read(File subscriptionKeyLocation) throws IOException {
        if (!subscriptionKeyLocation.exists()) {
            return null;
        }
        try (FileInputStream is = new FileInputStream(subscriptionKeyLocation);){
            SubscriptionKey subscriptionKey = new SubscriptionKey(Util.toString(is));
            return subscriptionKey;
        }
    }

    public static SubscriptionKey get() {
        SubscriptionKey subscriptionKey = LocalSubscriptionKey.getSystemProperty();
        if (subscriptionKey != null) {
            LocalSubscriptionKey.getLogger().debug("Using subscription key from system property");
            return subscriptionKey;
        }
        subscriptionKey = LocalSubscriptionKey.getEnvironmentVariable();
        if (subscriptionKey != null) {
            LocalSubscriptionKey.getLogger().debug("Using subscription key from environment variable");
            return subscriptionKey;
        }
        File subscriptionKeyLocation = new File(LocalProKey.getVaadinFolder(), "subscriptionKey");
        try {
            subscriptionKey = LocalSubscriptionKey.read(subscriptionKeyLocation);
            if (subscriptionKey != null) {
                LocalSubscriptionKey.getLogger().debug("Found subscription key in " + subscriptionKeyLocation);
                return subscriptionKey;
            }
            return LocalSubscriptionKey.getFromLocalOfflineKey();
        }
        catch (IOException e) {
            LocalSubscriptionKey.getLogger().debug("Unable to read subscription key", e);
            return LocalSubscriptionKey.getFromLocalOfflineKey();
        }
    }

    public static Optional<SubscriptionKey> fromString(String key) {
        if (LocalSubscriptionKey.isSubscriptionKey(key)) {
            return Optional.of(new SubscriptionKey(key));
        }
        return Optional.empty();
    }

    private static SubscriptionKey getFromLocalOfflineKey() {
        String key;
        OfflineKey offlineKey = LocalOfflineKey.get();
        if (offlineKey != null && (key = offlineKey.getSubscriptionKey()) != null) {
            LocalSubscriptionKey.getLogger().debug("Using subscription key from offline key");
            return new SubscriptionKey(key);
        }
        return null;
    }

    public static SubscriptionKey getOrFail() {
        SubscriptionKey subscriptionKey = LocalSubscriptionKey.get();
        if (subscriptionKey == null) {
            throw new LicenseException("A subscription key is required for Daily Active User tracking, but it was not found. Please provide a valid subscription key by either setting VAADIN_SUBSCRIPTION_KEY environment variable, -Dvaadin.subscriptionKey system property or a $HOME/.vaadin/subscriptionKey file.");
        }
        return subscriptionKey;
    }

    private static SubscriptionKey getSystemProperty() {
        String value = System.getProperty(VAADIN_SUBSCRIPTION_KEY_SYSTEM_PROPERTY);
        if (value == null && !LocalSubscriptionKey.isSubscriptionKey(value = System.getProperty("vaadin.key"))) {
            return null;
        }
        return LocalSubscriptionKey.parseSubscriptionKey(value, "system property");
    }

    private static SubscriptionKey getEnvironmentVariable() {
        String value = EnvironmentVariables.get(VAADIN_SUBSCRIPTION_KEY_ENV_VAR);
        if (value == null && !LocalSubscriptionKey.isSubscriptionKey(value = EnvironmentVariables.get("VAADIN_KEY"))) {
            return null;
        }
        return LocalSubscriptionKey.parseSubscriptionKey(value, "environment variable");
    }

    private static SubscriptionKey parseSubscriptionKey(String value, String source) {
        if (!value.startsWith("sub-")) {
            LocalSubscriptionKey.getLogger().warn("Invalid subscription key format in the {}. The value must be of type [sub-123]. Was {}", (Object)source, (Object)value);
            return null;
        }
        return new SubscriptionKey(value);
    }

    private static boolean isSubscriptionKey(String value) {
        return value != null && value.startsWith("sub-");
    }

    private static Logger getLogger() {
        return LicenseChecker.getLogger();
    }
}

