/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.pro.licensechecker;

import com.vaadin.pro.licensechecker.DefaultMachineIdFileAccess;
import com.vaadin.pro.licensechecker.MachineIdFileAccess;
import com.vaadin.pro.licensechecker.OfflineKeyValidator;
import com.vaadin.pro.licensechecker.Util;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.ComputerSystem;
import oshi.hardware.HardwareAbstractionLayer;

public class MachineId {
    private static final MachineIdFileAccess DEFAULT_FILE_ACCESS = new DefaultMachineIdFileAccess();
    private final String v1Id;
    private final String v2FullId;
    private MachineIdFileAccess fileAccess;

    MachineId() {
        this(DEFAULT_FILE_ACCESS);
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(MachineId.class);
    }

    @Deprecated
    MachineId(String v1Id) {
        this.fileAccess = DEFAULT_FILE_ACCESS;
        this.v1Id = Objects.requireNonNull(v1Id);
        if (MachineId.isV2(v1Id)) {
            throw new IllegalArgumentException("String constructor only accepts v1 machine IDs. Got v2: " + v1Id);
        }
        String v2 = "";
        try {
            v2 = this.generateV2();
        }
        catch (Throwable e) {
            MachineId.getLogger().error("Failed to generate v2 Machine ID", e);
        }
        this.v2FullId = v2;
    }

    MachineId(String v1Id, String v2FullId) {
        this.v1Id = Objects.requireNonNull(v1Id);
        this.v2FullId = Objects.requireNonNull(v2FullId);
    }

    MachineId(MachineIdFileAccess fileAccess) {
        this.fileAccess = fileAccess;
        String v1 = null;
        String v2 = "";
        try {
            v1 = MachineId.generateV1();
        }
        catch (Throwable e) {
            MachineId.getLogger().debug("Failed to generate v1 Machine ID", e);
        }
        try {
            v2 = this.generateV2();
        }
        catch (Throwable e) {
            MachineId.getLogger().error("Failed to generate v2 Machine ID", e);
        }
        this.v1Id = v1;
        this.v2FullId = v2;
    }

    String getV1() {
        return this.v1Id;
    }

    String getV2Full() {
        return this.v2FullId;
    }

    String getPrimaryIdFull() {
        return this.getV2Full();
    }

    String getPrimaryIdStable() {
        return MachineId.extractStablePart(this.getV2Full());
    }

    boolean stablePartMatches(String licenseMachineId) {
        if (licenseMachineId == null || licenseMachineId.isEmpty()) {
            return false;
        }
        if (MachineId.isV2(licenseMachineId)) {
            return this.equalsV2StableId(licenseMachineId);
        }
        if (MachineId.isV1(licenseMachineId)) {
            if (this.v1Id == null) {
                String message = "Cannot generate V1 Machine ID: OSHI library not found.\nOSHI is required for V1 Machine IDs but will be made optional in a future version.\nEither:\n1. Add OSHI dependency to your project:\n   <dependency>\n     <groupId>com.github.oshi</groupId>\n     <artifactId>oshi-core</artifactId>\n     <version>6.9.1</version>\n   </dependency>\n2. Generate a new V2 offline license at: " + OfflineKeyValidator.getOfflineUrl(this.v2FullId);
                throw new IllegalStateException(message);
            }
            return licenseMachineId.equals(this.v1Id);
        }
        return false;
    }

    boolean equalsV2StableId(String machineId) {
        if (machineId == null || machineId.isEmpty()) {
            return false;
        }
        String currentStable = MachineId.extractStablePart(this.v2FullId);
        String providedStable = MachineId.extractStablePart(machineId);
        return currentStable.equals(providedStable);
    }

    boolean equalsV2FullId(String machineId) {
        if (machineId == null || machineId.isEmpty()) {
            return false;
        }
        return this.v2FullId.equals(machineId);
    }

    boolean equalsV1(String machineId) {
        if (machineId == null || machineId.isEmpty()) {
            return false;
        }
        return this.v1Id.equals(machineId);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println(new MachineId().getV1());
            return;
        }
        if (args.length > 0 && "--v2".equals(args[0])) {
            MachineId machineId = new MachineId();
            System.out.println("Machine ID v1 (current default):");
            System.out.println("  " + machineId.getV1());
            System.out.println();
            System.out.println("Machine ID v2:");
            System.out.println("  Full ID:   " + machineId.getV2Full());
            System.out.println("  Stable ID: " + MachineId.extractStablePart(machineId.getV2Full()));
        } else {
            System.out.println("Usage: java MachineId [--v2]");
            System.out.println("  (no args): Print v1 Machine ID");
            System.out.println("  --v2:      Print detailed v1 and v2 information");
        }
    }

    @Deprecated
    public static String get() {
        return new MachineId().getPrimaryIdFull();
    }

    private static String generateV1() {
        try {
            SystemInfo systemInfo = new SystemInfo();
            HardwareAbstractionLayer hardwareAbstractionLayer = systemInfo.getHardware();
            ComputerSystem computerSystem = hardwareAbstractionLayer.getComputerSystem();
            String uuid = computerSystem.getHardwareUUID();
            CentralProcessor centralProcessor = hardwareAbstractionLayer.getProcessor();
            String processorIdentifier = centralProcessor.getProcessorIdentifier().getIdentifier();
            String delimiter = "-";
            return "mid-" + String.format("%08x", uuid.hashCode()) + delimiter + String.format("%08x", processorIdentifier.hashCode());
        }
        catch (NoClassDefFoundError e) {
            MachineId.getLogger().debug("OSHI library not found, V1 Machine ID generation not available", e);
            return null;
        }
    }

    String generateV2() throws Exception {
        String uniquePart;
        String stablePart;
        Path homePath = this.fileAccess.getUserHome();
        String homePathStr = homePath.toAbsolutePath().toString();
        MachineIdFileAccess.FileAttributes attrs = this.fileAccess.getFileAttributes(homePath);
        FileTime creationTime = attrs.getCreationTime();
        FileTime modifiedTime = attrs.getLastModifiedTime();
        long timestamp = creationTime.toMillis();
        if (!creationTime.equals(modifiedTime)) {
            stablePart = Util.getHashPrefix(homePathStr + ":" + timestamp, null, StandardCharsets.UTF_8, 8);
            uniquePart = "00000000";
        } else {
            stablePart = Util.getHashPrefix(homePathStr, null, StandardCharsets.UTF_8, 8);
            uniquePart = Util.getHashPrefix(String.valueOf(timestamp), null, StandardCharsets.UTF_8, 8);
        }
        return "mid2-" + stablePart + "-" + uniquePart;
    }

    static boolean isV1(String machineId) {
        if (machineId == null) {
            return false;
        }
        if ("aa1122".equals(machineId)) {
            return true;
        }
        return machineId.startsWith("mid-");
    }

    static boolean isV2(String machineId) {
        return machineId != null && machineId.startsWith("mid2-");
    }

    static String extractStablePart(String machineId) {
        if (machineId == null) {
            return "";
        }
        if (MachineId.isV1(machineId)) {
            return machineId;
        }
        if (MachineId.isV2(machineId)) {
            int lastDash;
            int firstDash = machineId.indexOf(45);
            if (firstDash == (lastDash = machineId.lastIndexOf(45))) {
                return machineId;
            }
            return machineId.substring(0, lastDash);
        }
        return machineId;
    }
}

