/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.pro.licensechecker;

import com.vaadin.pro.licensechecker.EnvironmentVariables;
import com.vaadin.pro.licensechecker.LicenseChecker;
import com.vaadin.pro.licensechecker.ProKey;
import com.vaadin.pro.licensechecker.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Optional;
import org.slf4j.Logger;

public class LocalProKey {
    private static ProKey read(File proKeyLocation) throws IOException {
        if (!proKeyLocation.exists()) {
            return null;
        }
        try (FileInputStream is = new FileInputStream(proKeyLocation);){
            ProKey proKey = ProKey.fromJson(Util.toString(is));
            return proKey;
        }
    }

    public static File getVaadinFolder() {
        String userHome = System.getProperty("user.home");
        return new File(userHome, ".vaadin");
    }

    public static File getLocation() {
        return new File(LocalProKey.getVaadinFolder(), "proKey");
    }

    public static ProKey get() {
        ProKey proKey = LocalProKey.getSystemProperty();
        if (proKey != null) {
            LocalProKey.getLogger().debug("Using proKey from system property");
            return proKey;
        }
        proKey = LocalProKey.getEnvironmentVariable();
        if (proKey != null) {
            LocalProKey.getLogger().debug("Using proKey from environment variable");
            return proKey;
        }
        File proKeyLocation = LocalProKey.getLocation();
        try {
            proKey = LocalProKey.read(proKeyLocation);
            if (proKey != null) {
                LocalProKey.getLogger().debug("Found proKey in " + proKeyLocation);
            }
            return proKey;
        }
        catch (IOException e) {
            LocalProKey.getLogger().debug("Unable to read proKey", e);
            return null;
        }
    }

    public static Optional<ProKey> fromString(String key) {
        if (LocalProKey.isProKey(key)) {
            return Optional.ofNullable(LocalProKey.parseProKey(key, null));
        }
        return Optional.empty();
    }

    private static ProKey getSystemProperty() {
        String value = System.getProperty("vaadin.proKey");
        if (value == null && !LocalProKey.isProKey(value = System.getProperty("vaadin.key"))) {
            return null;
        }
        return LocalProKey.parseProKey(value, "system property");
    }

    private static ProKey getEnvironmentVariable() {
        String value = EnvironmentVariables.get("VAADIN_PRO_KEY");
        if (value == null && !LocalProKey.isProKey(value = EnvironmentVariables.get("VAADIN_KEY"))) {
            return null;
        }
        return LocalProKey.parseProKey(value, "environment variable");
    }

    private static ProKey parseProKey(String value, String source) {
        String username = "";
        String key = "";
        if (value.contains("/")) {
            String[] parts = value.split("/");
            username = parts[0];
            key = parts[1];
        } else if (value.startsWith("pro-")) {
            key = value;
        }
        if (key == null || key.isEmpty()) {
            if (source != null) {
                LocalProKey.getLogger().warn("Invalid pro key format in the " + source + ". The value must be either of type [vaadin.com login email]/[pro-123] or [pro-123]. Was " + value);
            }
            return null;
        }
        return new ProKey(username, key);
    }

    private static boolean isProKey(String value) {
        if (value == null) {
            return false;
        }
        return value.contains("pro-");
    }

    public static boolean write(ProKey proKey) {
        boolean bl;
        File proKeyLocation = LocalProKey.getLocation();
        File proKeyDirectory = LocalProKey.getLocation().getParentFile();
        if (!proKeyDirectory.exists()) {
            proKeyDirectory.mkdirs();
        }
        LocalProKey.getLogger().debug("Writing pro key to " + proKeyLocation);
        FileWriter writer = new FileWriter(proKeyLocation);
        try {
            writer.write(proKey.toJson());
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LocalProKey.getLogger().error("Unable to write key to " + proKeyLocation, e);
                return false;
            }
        }
        writer.close();
        return bl;
    }

    private static Logger getLogger() {
        return LicenseChecker.getLogger();
    }
}

