/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.pro.licensechecker;

import com.vaadin.pro.licensechecker.LicenseChecker;
import com.vaadin.pro.licensechecker.json.LicenseCheckerJson;
import com.vaadin.pro.licensechecker.json.LicenseCheckerJsonObject;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.UUID;
import org.slf4j.Logger;

class UserKey {
    static final String PROPERTY_USER_HOME = "user.home";
    static final String VAADIN_FOLDER_NAME = ".vaadin";
    static final String USER_KEY_FILE_NAME = "userKey";
    private final String key;

    UserKey(String key) {
        this.key = key;
    }

    String getKey() {
        return this.key;
    }

    static UserKey get() {
        File userKeyFile = UserKey.resolveUserKeyLocation();
        if (userKeyFile.exists()) {
            return UserKey.fromFile(userKeyFile);
        }
        return UserKey.toFile(userKeyFile, new UserKey("user-" + UUID.randomUUID()));
    }

    private static UserKey toFile(File userKeyFile, UserKey userKey) {
        try {
            userKeyFile.getParentFile().mkdirs();
            LicenseCheckerJsonObject userKeyJson = LicenseCheckerJson.createObject();
            userKeyJson.put("key", userKey.getKey());
            Files.write(userKeyFile.toPath(), userKeyJson.toJson().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            return userKey;
        }
        catch (IOException e) {
            UserKey.getLogger().debug("Failed to write generated UserKey", e);
            return null;
        }
    }

    private static UserKey fromFile(File userKeyFile) {
        try {
            String userKeyJson = new String(Files.readAllBytes(userKeyFile.toPath()), StandardCharsets.UTF_8);
            LicenseCheckerJsonObject json = LicenseCheckerJson.parse(userKeyJson);
            return new UserKey(json.getString("key"));
        }
        catch (Exception e) {
            UserKey.getLogger().debug("Unable to read UserKey", e);
            return null;
        }
    }

    static File resolveUserKeyLocation() {
        String userHome = System.getProperty(PROPERTY_USER_HOME);
        File vaadinHome = new File(userHome, VAADIN_FOLDER_NAME);
        return new File(vaadinHome, USER_KEY_FILE_NAME);
    }

    private static Logger getLogger() {
        return LicenseChecker.getLogger();
    }
}

