/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.pro.licensechecker;

import com.vaadin.pro.licensechecker.Util;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.ComputerSystem;
import oshi.hardware.HardwareAbstractionLayer;

public class MachineId {
    private static String computerId;
    private static String computerIdV2;

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println(MachineId.get());
            return;
        }
        if (args.length > 0 && "--v2".equals(args[0])) {
            System.out.println("Machine ID v1 (current default):");
            System.out.println("  " + MachineId.get());
            System.out.println();
            System.out.println("Machine ID v2:");
            System.out.println("  Full ID:   " + MachineId.getV2FullId());
            System.out.println("  Stable ID: " + MachineId.getV2StableId());
        } else {
            System.out.println("Usage: java MachineId [--v2]");
            System.out.println("  (no args): Print v1 Machine ID");
            System.out.println("  --v2:      Print detailed v1 and v2 information");
        }
    }

    public static String get() {
        if (computerId == null) {
            try {
                computerId = MachineId.getComputerId();
            }
            catch (Throwable e) {
                computerId = "";
            }
        }
        return computerId;
    }

    private static String getComputerId() {
        SystemInfo systemInfo = new SystemInfo();
        HardwareAbstractionLayer hardwareAbstractionLayer = systemInfo.getHardware();
        ComputerSystem computerSystem = hardwareAbstractionLayer.getComputerSystem();
        String uuid = computerSystem.getHardwareUUID();
        CentralProcessor centralProcessor = hardwareAbstractionLayer.getProcessor();
        String processorIdentifier = centralProcessor.getProcessorIdentifier().getIdentifier();
        String delimiter = "-";
        return "mid-" + String.format("%08x", uuid.hashCode()) + delimiter + String.format("%08x", processorIdentifier.hashCode());
    }

    public static String getV2FullId() {
        if (computerIdV2 == null) {
            try {
                computerIdV2 = MachineId.generateV2();
            }
            catch (Throwable e) {
                computerIdV2 = "";
            }
        }
        return computerIdV2;
    }

    public static String getV2StableId() {
        String fullId = MachineId.getV2FullId();
        if (fullId.isEmpty()) {
            return "";
        }
        return MachineId.extractStablePart(fullId);
    }

    private static String generateV2() throws Exception {
        Path homePath = Paths.get(System.getProperty("user.home"), new String[0]);
        String homePathStr = homePath.toAbsolutePath().toString();
        String stablePart = Util.getHashPrefix(homePathStr, null, StandardCharsets.UTF_8, 8);
        BasicFileAttributes attrs = Files.readAttributes(homePath, BasicFileAttributes.class, new LinkOption[0]);
        FileTime creationTime = attrs.creationTime();
        if (creationTime.toMillis() == 0L) {
            creationTime = attrs.lastModifiedTime();
        }
        String uniquePart = Util.getHashPrefix(String.valueOf(creationTime.toMillis()), null, StandardCharsets.UTF_8, 8);
        return "mid2-" + stablePart + "-" + uniquePart;
    }

    public static boolean isV1(String machineId) {
        return machineId != null && machineId.startsWith("mid-");
    }

    public static boolean isV2(String machineId) {
        return machineId != null && machineId.startsWith("mid2-");
    }

    public static String extractStablePart(String machineId) {
        if (machineId == null) {
            return "";
        }
        if (MachineId.isV1(machineId)) {
            return machineId;
        }
        if (MachineId.isV2(machineId)) {
            int lastDash;
            int firstDash = machineId.indexOf(45);
            if (firstDash == (lastDash = machineId.lastIndexOf(45))) {
                return machineId;
            }
            return machineId.substring(0, lastDash);
        }
        return machineId;
    }

    public static boolean equalsV2StableId(String machineId) {
        if (machineId == null || machineId.isEmpty()) {
            return false;
        }
        String currentStable = MachineId.extractStablePart(MachineId.getV2FullId());
        String providedStable = MachineId.extractStablePart(machineId);
        return currentStable.equals(providedStable);
    }

    public static boolean equalsV2FullId(String machineId) {
        if (machineId == null || machineId.isEmpty()) {
            return false;
        }
        return MachineId.getV2FullId().equals(machineId);
    }
}

