/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.kubernetes.starter.sessiontracker.serialization.debug;

import com.vaadin.kubernetes.starter.sessiontracker.backend.SessionInfo;
import com.vaadin.kubernetes.starter.sessiontracker.serialization.debug.DebugMode;
import com.vaadin.kubernetes.starter.sessiontracker.serialization.debug.Outcome;
import com.vaadin.kubernetes.starter.sessiontracker.serialization.debug.Result;
import com.vaadin.kubernetes.starter.sessiontracker.serialization.debug.Track;
import java.io.InvalidObjectException;
import java.io.ObjectStreamClass;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Job {
    private static final Pattern SERIALIZEDLAMBDA_CANNOT_ASSIGN = Pattern.compile("cannot assign instance of java.lang.invoke.SerializedLambda to field [^ ]+ of type ([^ ]+) in instance [^ ]+");
    private static final Pattern SERIALIZEDLAMBDA_CANNOT_CAST = Pattern.compile("class java.lang.invoke.SerializedLambda cannot be cast to class ([^ ]+)( |$)");
    private final CountDownLatch serializationCompletedLatch = new CountDownLatch(1);
    private final CountDownLatch serializationStartedLatch = new CountDownLatch(1);
    private final String sessionId;
    private long startTimeNanos;
    private final Set<Outcome> outcome = new LinkedHashSet<Outcome>();
    private final Map<String, List<String>> messages = new LinkedHashMap<String, List<String>>();
    private String clusterKey;
    private final Map<Object, Track> tracked = new IdentityHashMap<Object, Track>();
    private final Map<Integer, Track> trackedById = new IdentityHashMap<Integer, Track>();
    private final Map<Integer, Track> trackedByHandle = new IdentityHashMap<Integer, Track>();
    private final ArrayDeque<Track> deserializingStack = new ArrayDeque();
    private final Map<String, List<String>> unserializableDetails = new HashMap<String, List<String>>();
    private final Map<Integer, SerializedLambda> serializedLambdaMap = new HashMap<Integer, SerializedLambda>();

    Job(String sessionId, String clusterKey) {
        this.sessionId = sessionId;
        this.clusterKey = clusterKey;
        this.startTimeNanos = System.nanoTime();
    }

    boolean waitForSerializationCompletion(int timeout, Logger logger) {
        boolean completed = true;
        try {
            completed = this.serializationStartedLatch.await(timeout, TimeUnit.MILLISECONDS);
            if (!completed) {
                this.timeout();
                logger.error("Session serialization timed out because it did not start in {} ms, most likely because another attempt is already in progress.", (Object)timeout);
                return false;
            }
        }
        catch (Exception e) {
            logger.error("Testing of session serialization failed", (Throwable)e);
        }
        if (completed) {
            try {
                completed = this.serializationCompletedLatch.await(timeout, TimeUnit.MILLISECONDS);
                if (!completed) {
                    this.timeout();
                    logger.error("Session serialization timed out because it did not complete in {} ms. Increase the serialization timeout (in milliseconds) using the 'vaadin.serialization.timeout' application or system property.", (Object)timeout);
                    return false;
                }
            }
            catch (Exception e) {
                logger.error("Testing of session serialization failed", (Throwable)e);
            }
        }
        return completed;
    }

    boolean isRunning(String sessionId) {
        return this.sessionId.equals(sessionId) && this.serializationStartedLatch.getCount() > 0L || this.serializationCompletedLatch.getCount() > 0L;
    }

    void reset() {
        this.startTimeNanos = System.nanoTime();
        this.outcome.clear();
        this.messages.clear();
        this.tracked.clear();
        this.trackedById.clear();
        this.trackedByHandle.clear();
        this.deserializingStack.clear();
        this.unserializableDetails.clear();
        this.serializedLambdaMap.clear();
        this.outcome.add(Outcome.SERIALIZATION_FAILED);
    }

    void cancel() {
        this.outcome.add(Outcome.CANCELED);
        this.releaseLocks();
    }

    public void serializationStarted() {
        this.serializationStartedLatch.countDown();
        this.reset();
    }

    void notSerializable(Object obj) {
        Class<?> clazz = obj.getClass();
        Track track = this.tracked.get(obj);
        List details = this.unserializableDetails.computeIfAbsent(clazz.getName(), unused -> {
            ArrayList<String> info = new ArrayList<String>();
            if (clazz.isSynthetic() && !clazz.isAnonymousClass() && !clazz.isLocalClass() && clazz.getSimpleName().contains("$$Lambda$") && clazz.getInterfaces().length == 1) {
                Class<?> samInterface = clazz.getInterfaces()[0];
                Method samMethod = samInterface.getMethods()[0];
                StringJoiner sj = new StringJoiner(",", samMethod.getName() + "(", ")");
                for (Class<?> parameterType : samMethod.getParameterTypes()) {
                    sj.add(parameterType.getTypeName());
                }
                info.add(String.format("[ SAM interface: %s.%s ]", samInterface.getName(), sj));
            }
            return info;
        });
        if (!track.stackInfo.isEmpty()) {
            details.add(String.format("Start Track ID: %d, Stack depth: %d. Reference stack: ", track.id, track.depth));
            details.addAll(track.stackInfo);
            details.add(String.format("End Track ID: %d", track.id));
            details.add("");
        }
        this.logDistinct(Outcome.NOT_SERIALIZABLE_CLASSES.name(), clazz.getName());
        this.outcome.add(Outcome.NOT_SERIALIZABLE_CLASSES);
    }

    void serialized(SessionInfo info) {
        try {
            if (info != null) {
                if (!this.clusterKey.equals(info.getClusterKey())) {
                    throw new IllegalStateException("Unexpected cluster key " + info.getClusterKey() + " on session info, expecting it to be " + this.clusterKey);
                }
                this.clusterKey = info.getClusterKey();
                this.outcome.add(Outcome.DESERIALIZATION_FAILED);
                if (!this.outcome.contains((Object)Outcome.NOT_SERIALIZABLE_CLASSES)) {
                    this.outcome.remove((Object)Outcome.SERIALIZATION_FAILED);
                }
            }
        }
        finally {
            this.serializationCompletedLatch.countDown();
        }
    }

    void serializationFailed(Exception ex) {
        this.outcome.add(Outcome.SERIALIZATION_FAILED);
        this.log("ERRORS", Outcome.SERIALIZATION_FAILED.name() + ": " + ex.getMessage());
    }

    void timeout() {
        this.outcome.remove((Object)Outcome.SERIALIZATION_FAILED);
        this.outcome.add(Outcome.SERIALIZATION_TIMEOUT);
        this.releaseLocks();
    }

    private void releaseLocks() {
        if (this.serializationStartedLatch.getCount() > 0L) {
            this.serializationStartedLatch.countDown();
        }
        if (this.serializationCompletedLatch.getCount() > 0L) {
            this.serializationCompletedLatch.countDown();
        }
    }

    void deserializationStarted() {
        this.trackedByHandle.clear();
        this.trackedByHandle.putAll(this.tracked.values().stream().filter(t -> t.getHandle() != -1).collect(Collectors.toMap(Track::getHandle, Function.identity())));
    }

    void deserialized() {
        this.outcome.remove((Object)Outcome.DESERIALIZATION_FAILED);
    }

    void deserializationFailed(Exception ex) {
        this.outcome.add(Outcome.DESERIALIZATION_FAILED);
        this.log("ERRORS", Outcome.DESERIALIZATION_FAILED.name() + ": " + ex.getMessage());
        Throwable cause = this.tryUnwrapLambdaDeserializationCause(ex);
        if (cause instanceof ClassCastException && cause.getMessage().contains(SerializedLambda.class.getName()) && !this.serializedLambdaMap.isEmpty()) {
            String bestCandidates;
            String targetType = Job.tryDetectClassCastTarget(cause.getMessage());
            if (targetType != null && !(bestCandidates = this.serializedLambdaMap.values().stream().filter(serializedLambda -> serializedLambda.getFunctionalInterfaceClass().equals(targetType.replace('.', '/'))).flatMap(serializedLambda -> Stream.concat(Stream.of("\t" + String.valueOf(serializedLambda)), this.tracked.get((Object)serializedLambda).stackInfo.stream())).collect(Collectors.joining(System.lineSeparator()))).isEmpty()) {
                this.log("ERRORS", "SERIALIZED LAMBDA CLASS CAST EXCEPTION BEST CANDIDATES:" + System.lineSeparator() + "=======================================================" + System.lineSeparator() + bestCandidates);
            }
        } else {
            this.dumpDeserializationStack().ifPresent(message -> this.log("ERRORS", (String)message));
        }
    }

    private Throwable tryUnwrapLambdaDeserializationCause(Throwable exception) {
        Throwable cause = exception;
        if (cause instanceof InvalidObjectException) {
            cause = cause.getCause();
        }
        if (cause instanceof InvocationTargetException) {
            cause = cause.getCause();
        }
        return cause;
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(DebugMode.class);
    }

    void pushDeserialization(Track track, Object obj) {
        if (obj instanceof SerializedLambda) {
            int trackId = track.id;
            Object serializedObject = Optional.of(this.trackedById.get(trackId)).map(t -> t.object).orElse(null);
            if (serializedObject instanceof SerializedLambda) {
                SerializedLambda cast = (SerializedLambda)serializedObject;
                this.serializedLambdaMap.put(trackId, cast);
            } else {
                this.getLogger().warn("Expected tracked object {} to be instance of {}, but was {} ", new Object[]{trackId, SerializedLambda.class.getName(), serializedObject == null ? "NULL" : serializedObject.getClass()});
            }
        }
        if (obj instanceof ObjectStreamClass) {
            this.getLogger().trace("Push deserialization stack element Track ID: {}, Handle: {} (estimated: {}), depth: {}, desc; {}", new Object[]{track.id, track.getHandle(), track.id == -1, track.depth, obj});
            this.deserializingStack.push(track);
        }
    }

    void popDeserialization(Track track, Object obj) {
        if (track != null && this.serializedLambdaMap.containsKey(track.id) && !(obj instanceof SerializedLambda)) {
            this.serializedLambdaMap.remove(track.id);
        }
        if (!this.deserializingStack.isEmpty()) {
            Track pop = this.deserializingStack.pop();
            this.getLogger().trace("Pop deserialization stack element Track ID: {}, Handle: {} (estimated: {}), depth: {}", new Object[]{pop.id, pop.getHandle(), pop.id == -1, pop.depth});
        }
    }

    Optional<String> dumpDeserializationStack() {
        if (!this.deserializingStack.isEmpty()) {
            return Optional.of(this.deserializingStack.peek()).flatMap(stackEntry -> Optional.ofNullable(this.trackedByHandle.get(stackEntry.getHandle()))).map(track -> {
                StringJoiner joiner = new StringJoiner(System.lineSeparator());
                joiner.add("DESERIALIZATION STACK. Process failed at depth " + track.depth);
                joiner.add("\t- object (class \"" + track.className + "\")");
                if (!track.stackInfo.isEmpty()) {
                    track.stackInfo.forEach(joiner::add);
                }
                return joiner.toString();
            });
        }
        return Optional.empty();
    }

    Result complete() {
        this.releaseLocks();
        if (this.outcome.isEmpty()) {
            this.outcome.add(Outcome.SUCCESS);
        }
        long duration = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.startTimeNanos);
        if (!this.outcome.contains((Object)Outcome.SERIALIZATION_TIMEOUT)) {
            this.messages.computeIfPresent(Outcome.NOT_SERIALIZABLE_CLASSES.name(), (unused, info) -> info.stream().flatMap(className -> Stream.concat(Stream.of(className), this.unserializableDetails.getOrDefault(className, Collections.emptyList()).stream().map(entry -> "\t" + entry))).collect(Collectors.toList()));
        }
        return new Result(this.sessionId, this.clusterKey, this.outcome, duration, this.messages);
    }

    void log(String category, String message) {
        this.messages.computeIfAbsent(category, unused -> new ArrayList()).add(message);
    }

    void logDistinct(String category, String message) {
        List list = this.messages.computeIfAbsent(category, unused -> new ArrayList());
        if (!list.contains(message)) {
            list.add(message);
        }
    }

    private static String tryDetectClassCastTarget(String message) {
        Matcher matcher = SERIALIZEDLAMBDA_CANNOT_ASSIGN.matcher(message);
        if (matcher.find()) {
            return matcher.group(1);
        }
        matcher = SERIALIZEDLAMBDA_CANNOT_CAST.matcher(message);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public void track(Object object, Track track) {
        if (track == null) {
            track = new Track(-1, -1, null, null);
        } else {
            this.trackedById.put(track.id, track);
        }
        this.tracked.put(object, track);
    }
}

