/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.kubernetes.starter.sessiontracker.serialization.debug;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;

class FailingToStringReplacer
implements Serializable {
    private transient Serializable target;
    private final Class<?> targetClass;

    FailingToStringReplacer(Serializable target) {
        this.target = target;
        this.targetClass = target.getClass();
    }

    static Object wrapIfNeeded(Serializable target) {
        if (target != null) {
            try {
                target.toString();
            }
            catch (Exception ex) {
                target = new FailingToStringReplacer(target);
            }
        }
        return target;
    }

    public String toString() {
        return "Replacement for " + String.valueOf(this.target.getClass()) + " because of throwing toString()";
    }

    private void writeObject(ObjectOutputStream os) throws IOException {
        os.defaultWriteObject();
        ObjectStreamClass lookup = ObjectStreamClass.lookup(this.targetClass);
        this.writeSerialData(os, this.target, lookup);
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        is.defaultReadObject();
        ObjectStreamClass descr = ObjectStreamClass.lookup(this.targetClass);
        this.target = (Serializable)this.newInstance(descr);
        this.readSerialData(is, this.target, descr);
    }

    private Object readResolve() {
        return this.target;
    }

    private Object newInstance(ObjectStreamClass descr) {
        try {
            return MethodHandles.privateLookupIn(ObjectStreamClass.class, MethodHandles.lookup()).findVirtual(ObjectStreamClass.class, "newInstance", MethodType.methodType(Object.class)).invoke(descr);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private void writeSerialData(ObjectOutputStream oos, Object obj, ObjectStreamClass desc) {
        try {
            MethodHandles.privateLookupIn(ObjectOutputStream.class, MethodHandles.lookup()).findVirtual(ObjectOutputStream.class, "writeSerialData", MethodType.methodType(Void.TYPE, Object.class, ObjectStreamClass.class)).bindTo(oos).invoke(obj, desc);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private void readSerialData(ObjectInputStream is, Object obj, ObjectStreamClass desc) {
        try {
            MethodHandles.privateLookupIn(ObjectInputStream.class, MethodHandles.lookup()).findVirtual(ObjectInputStream.class, "readSerialData", MethodType.methodType(Void.TYPE, Object.class, ObjectStreamClass.class)).bindTo(is).invoke(obj, desc);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

