/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.kubernetes.starter.sessiontracker.serialization;

import com.vaadin.flow.dom.Element;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.kubernetes.starter.sessiontracker.UnserializableComponentWrapper;
import com.vaadin.kubernetes.starter.sessiontracker.UnserializableComponentWrapperFoundException;
import com.vaadin.kubernetes.starter.sessiontracker.serialization.SerializationOutputStream;
import com.vaadin.kubernetes.starter.sessiontracker.serialization.TransientAwareHolder;
import com.vaadin.kubernetes.starter.sessiontracker.serialization.TransientDescriptor;
import com.vaadin.kubernetes.starter.sessiontracker.serialization.TransientHandler;
import com.vaadin.kubernetes.starter.sessiontracker.serialization.debug.DebugMode;
import com.vaadin.kubernetes.starter.sessiontracker.serialization.debug.Track;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransientInjectableObjectOutputStream
extends SerializationOutputStream {
    static final Pattern INSPECTION_REJECTION_PATTERN = Pattern.compile("^(javax?|jakarta|com\\.sun|sun\\.misc)\\..*");
    private static final Predicate<Class<?>> DEFAULT_INSPECTION_FILTER = type -> !INSPECTION_REJECTION_PATTERN.matcher(type.getPackageName()).matches();
    private final TransientHandler inspector;
    private final IdentityHashMap<Object, TransientAwareHolder> inspected = new IdentityHashMap();
    private final Predicate<Class<?>> injectableFilter;
    private final Set<UnserializableComponentWrapper<?, ?>> unserializableComponents = new HashSet();
    private final OutputStream outputStream;
    private final VarHandle depthHandle;
    private final MethodHandle lookupObject;
    private final VarHandle debugStackInfo;
    private final VarHandle debugStackInfoList;
    private final IdentityHashMap<Object, Track> tracking = new IdentityHashMap();
    private final boolean trackingEnabled;
    private boolean trackingMode = false;
    private int trackingCounter;

    private TransientInjectableObjectOutputStream(OutputStream out, TransientHandler inspector, Predicate<Class<?>> injectableFilter) throws IOException {
        super(out);
        Objects.requireNonNull(injectableFilter, "transient inspection filter");
        this.inspector = Objects.requireNonNull(inspector, "transient handler");
        if (injectableFilter != DEFAULT_INSPECTION_FILTER) {
            injectableFilter = DEFAULT_INSPECTION_FILTER.and(injectableFilter);
        }
        this.injectableFilter = injectableFilter;
        this.outputStream = out;
        this.enableReplaceObject(true);
        if (this.inspector instanceof DebugMode && DebugMode.isTrackingAvailable()) {
            this.depthHandle = TransientInjectableObjectOutputStream.tryGetDepthHandle();
            this.lookupObject = this.tryGetLookupObject();
            this.debugStackInfo = TransientInjectableObjectOutputStream.tryGetDebugStackHandle();
            this.debugStackInfoList = TransientInjectableObjectOutputStream.tryGetDebugStackListHandle();
            this.trackingEnabled = true;
        } else {
            this.depthHandle = null;
            this.debugStackInfo = null;
            this.debugStackInfoList = null;
            this.lookupObject = null;
            this.trackingEnabled = false;
        }
    }

    public static TransientInjectableObjectOutputStream newInstance(OutputStream out, TransientHandler inspector) throws IOException {
        return TransientInjectableObjectOutputStream.newInstance(out, inspector, type -> true);
    }

    public static TransientInjectableObjectOutputStream newInstance(OutputStream out, TransientHandler inspector, Predicate<Class<?>> injectableFilter) throws IOException {
        if (inspector instanceof DebugMode && DebugMode.isTrackingAvailable()) {
            return new TransientInjectableObjectOutputStream(new InternalOutputStream(out), inspector, injectableFilter);
        }
        return new TransientInjectableObjectOutputStream(out, inspector, injectableFilter);
    }

    @Override
    public void writeWithTransients(Object object) throws IOException {
        this.inspected.clear();
        this.tracking.clear();
        if (this.inspector instanceof DebugMode) {
            ((DebugMode)((Object)this.inspector)).onSerializationStart();
        }
        try {
            this.reset();
            this.writeObject(this.trackingEnabled);
            this.trackingMode = true;
            this.writeObject(object);
            this.trackingMode = false;
            this.unserializableComponents.forEach(UnserializableComponentWrapper::afterSerialization);
            this.writeObject(new ArrayList(this.inspected.values().stream().filter(Objects::nonNull).collect(Collectors.toList())));
            this.flush();
            this.writeTrackingMetadata();
        }
        finally {
            this.unserializableComponents.clear();
            this.inspected.clear();
            this.tracking.clear();
            this.trackingMode = false;
        }
    }

    private void writeTrackingMetadata() throws IOException {
        if (this.outputStream instanceof InternalOutputStream && this.trackingEnabled) {
            InternalOutputStream cast = (InternalOutputStream)this.outputStream;
            List trackList = this.tracking.values().stream().filter(Objects::nonNull).map(t -> t.assignHandle(this::lookupObjectHandle)).filter(t -> t.getHandle() != -1).collect(Collectors.toList());
            cast.markMetadata();
            this.reset();
            this.writeStreamHeader();
            this.writeObject(true);
            this.writeObject(new ArrayList(trackList));
            cast.copy();
        }
    }

    @Override
    protected void writeClassDescriptor(ObjectStreamClass desc) throws IOException {
        super.writeClassDescriptor(desc);
        this.trackClass(desc);
        this.trackObject(desc);
    }

    @Override
    protected Object replaceObject(Object obj) {
        Class<?> type;
        Element element;
        Object var5_3;
        if ((obj = this.trackObject(obj)) instanceof Element && (var5_3 = (element = (Element)obj).getComponent().orElse(null)) instanceof UnserializableComponentWrapper) {
            UnserializableComponentWrapper wrapper = var5_3;
            this.handleUnserializableComponentWrapper(wrapper);
        } else if (obj instanceof UnserializableComponentWrapper) {
            UnserializableComponentWrapper wrapper = (UnserializableComponentWrapper)((Object)obj);
            this.handleUnserializableComponentWrapper(wrapper);
        }
        if (this.trackingMode && obj != null && this.injectableFilter.test(type = obj.getClass()) && !this.inspected.containsKey(obj)) {
            TransientAwareHolder holder;
            Object original = obj;
            if (!(obj instanceof Serializable) && this.inspector instanceof DebugMode) {
                obj = this.handleNotSerializable(obj);
            }
            if (obj != null) {
                List<TransientDescriptor> descriptors = this.inspector.inspect(obj);
                if (descriptors.isEmpty()) {
                    TransientInjectableObjectOutputStream.getLogger().trace("No injectable transient fields found for instance of class {}", obj.getClass());
                    holder = null;
                } else {
                    TransientInjectableObjectOutputStream.getLogger().trace("Found injectable transient fields for instance of class {} : {}", obj.getClass(), descriptors);
                    holder = new TransientAwareHolder(obj, descriptors);
                }
            } else {
                TransientInjectableObjectOutputStream.getLogger().debug("Object of type {} will be replaced with NULL and ignored", original.getClass());
                holder = TransientAwareHolder.NULL;
            }
            this.inspected.put(original, holder);
        }
        return obj;
    }

    private void handleUnserializableComponentWrapper(UnserializableComponentWrapper<?, ?> wrapper) {
        if (!this.unserializableComponents.contains(wrapper) && !wrapper.isAttached()) {
            if (VaadinSession.getCurrent() == null || !VaadinSession.getCurrent().hasLock()) {
                throw new UnserializableComponentWrapperFoundException("Detached " + UnserializableComponentWrapper.class.getName() + " component detected.");
            }
            UnserializableComponentWrapper.beforeSerialization(wrapper);
            this.unserializableComponents.add(wrapper);
        }
    }

    protected Object handleNotSerializable(Object obj) {
        DebugMode debugMode = (DebugMode)((Object)this.inspector);
        Object replace = debugMode.onNotSerializableFound(obj).map(Object.class::cast).orElse(obj);
        if (replace == DebugMode.NULLIFY) {
            TransientInjectableObjectOutputStream.getLogger().debug("Unserializable object of type {} replaced with null", obj.getClass());
            return null;
        }
        return replace;
    }

    private Object trackObject(Object obj) {
        if (this.trackingMode && this.trackingEnabled && !this.tracking.containsKey(obj)) {
            if (TransientInjectableObjectOutputStream.getLogger().isTraceEnabled()) {
                TransientInjectableObjectOutputStream.getLogger().trace("Serializing object {}", obj.getClass());
            }
            Object original = obj;
            try {
                Track track = this.createTrackObject(++this.trackingCounter, obj);
                this.tracking.put(obj, track);
                obj = ((DebugMode)((Object)this.inspector)).onSerialize(obj, track);
                if (obj == null) {
                    TransientInjectableObjectOutputStream.getLogger().debug("Object of type {} will be replaced with NULL and ignored", original.getClass());
                } else if (obj != original) {
                    TransientInjectableObjectOutputStream.getLogger().debug("Object of type {} will be replaced by an object of type {}", original.getClass(), obj.getClass());
                }
            }
            catch (Exception ex) {
                TransientInjectableObjectOutputStream.getLogger().error("Error tracking object of type {}", original.getClass(), (Object)ex);
            }
        }
        return obj;
    }

    private int lookupObjectHandle(Object obj) {
        if (this.lookupObject != null) {
            try {
                return this.lookupObject.invoke(obj);
            }
            catch (Throwable ex) {
                TransientInjectableObjectOutputStream.getLogger().trace("Cannot lookup object", ex);
            }
        }
        return -1;
    }

    private static VarHandle tryGetDepthHandle() {
        try {
            return MethodHandles.privateLookupIn(ObjectOutputStream.class, MethodHandles.lookup()).findVarHandle(ObjectOutputStream.class, "depth", Integer.TYPE);
        }
        catch (Exception ex) {
            TransientInjectableObjectOutputStream.getLogger().trace("Cannot access ObjectOutputStream.depth field", (Throwable)ex);
            return null;
        }
    }

    private MethodHandle tryGetLookupObject() {
        try {
            VarHandle handles = TransientInjectableObjectOutputStream.tryGetHandle("handles", Class.forName("java.io.ObjectOutputStream$HandleTable"));
            if (handles != null) {
                return MethodHandles.privateLookupIn(ObjectOutputStream.class, MethodHandles.lookup()).findVirtual(handles.varType(), "lookup", MethodType.methodType(Integer.TYPE, Object.class)).bindTo(handles.get(this));
            }
        }
        catch (Exception ex) {
            TransientInjectableObjectOutputStream.getLogger().trace("Cannot access ObjectOutputStream.handles.lookupObject method", (Throwable)ex);
        }
        return null;
    }

    private static VarHandle tryGetHandle(String name, Class<?> type) {
        try {
            return MethodHandles.privateLookupIn(ObjectOutputStream.class, MethodHandles.lookup()).findVarHandle(ObjectOutputStream.class, name, type);
        }
        catch (Exception ex) {
            TransientInjectableObjectOutputStream.getLogger().trace("Cannot access ObjectOutputStream.{} field", (Object)name, (Object)ex);
            return null;
        }
    }

    private static VarHandle tryGetDebugStackHandle() {
        try {
            return MethodHandles.privateLookupIn(ObjectOutputStream.class, MethodHandles.lookup()).findVarHandle(ObjectOutputStream.class, "debugInfoStack", Class.forName("java.io.ObjectOutputStream$DebugTraceInfoStack"));
        }
        catch (Exception ex) {
            TransientInjectableObjectOutputStream.getLogger().trace("Cannot access ObjectOutputStream.debugInfoStack field.", (Throwable)ex);
            return null;
        }
    }

    private static VarHandle tryGetDebugStackListHandle() {
        try {
            Class<?> debugTraceInfoStackClass = Class.forName("java.io.ObjectOutputStream$DebugTraceInfoStack");
            return MethodHandles.privateLookupIn(debugTraceInfoStackClass, MethodHandles.lookup()).findVarHandle(debugTraceInfoStackClass, "stack", List.class);
        }
        catch (Exception ex) {
            TransientInjectableObjectOutputStream.getLogger().trace("Cannot access ObjectOutputStream.DebugTraceInfoStack.stack field.", (Throwable)ex);
            return null;
        }
    }

    private Track createTrackObject(int id, Object obj) {
        Object stackElement;
        int depth = -1;
        if (this.depthHandle != null) {
            depth = this.depthHandle.get(this);
        }
        ArrayList stackInfo = null;
        if (this.debugStackInfo != null && (stackElement = this.debugStackInfo.get(this)) != null && this.debugStackInfoList != null) {
            stackInfo = new ArrayList(this.debugStackInfoList.get(stackElement));
            Collections.reverse(stackInfo);
        }
        return new Track(id, depth, stackInfo, obj);
    }

    private void trackClass(ObjectStreamClass type) {
        if (this.trackingMode && this.inspector instanceof DebugMode && TransientInjectableObjectOutputStream.getLogger().isTraceEnabled()) {
            String fields = Stream.of(type.getFields()).filter(field -> !field.isPrimitive() && !Serializable.class.isAssignableFrom(field.getType())).map(field -> String.format("%s %s", field.getType().getName(), field.getName())).collect(Collectors.joining(", "));
            TransientInjectableObjectOutputStream.getLogger().trace("Inspecting fields of class {} for serialization: [{}]", (Object)type.getName(), (Object)fields);
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(TransientInjectableObjectOutputStream.class);
    }

    private static class InternalOutputStream
    extends ByteArrayOutputStream {
        private final OutputStream wrapped;
        private int metadataPosition = -1;

        private InternalOutputStream(OutputStream wrapped) {
            this.wrapped = wrapped;
        }

        void markMetadata() {
            this.metadataPosition = this.count;
        }

        void copy() throws IOException {
            this.wrapped.write(Arrays.copyOfRange(this.buf, this.metadataPosition + 3, this.count));
            this.count = this.metadataPosition;
            this.writeTo(this.wrapped);
            this.count = 0;
            this.buf = new byte[0];
        }
    }
}

