/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.kubernetes.starter.sessiontracker.serialization.debug;

import com.vaadin.kubernetes.starter.sessiontracker.serialization.debug.Track;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Optional;
import org.slf4j.Logger;

public interface DebugMode {
    public static final Serializable NULLIFY = new Serializable(){

        public int hashCode() {
            return super.hashCode();
        }
    };

    default public void onSerializationStart() {
    }

    default public Optional<Serializable> onNotSerializableFound(Object object) {
        return Optional.empty();
    }

    default public Object onSerialize(Object object, Track track) {
        return object;
    }

    default public void onDeserializationStart() {
    }

    default public void onDeserialize(Class<?> type, Track track, Object object) {
    }

    default public Object onDeserialized(Object object, Track track) {
        return object;
    }

    public static boolean isTrackingAvailable(Logger logger) {
        boolean canAccessJavaIO;
        boolean logNotMetPreconditions;
        boolean extendedDebugInfo = Boolean.getBoolean("sun.io.serialization.extendedDebugInfo");
        boolean bl = logNotMetPreconditions = logger != null;
        if (!extendedDebugInfo && logNotMetPreconditions) {
            logger.warn("Serialization and deserialization traces cannot be detected if -Dsun.io.serialization.extendedDebugInfo system property is not enabled. Please add '-Dsun.io.serialization.extendedDebugInfo=true' to the JVM arguments.");
        }
        if (!(canAccessJavaIO = ObjectOutputStream.class.getModule().isOpen(ObjectOutputStream.class.getPackageName(), DebugMode.class.getModule())) && logNotMetPreconditions) {
            logger.warn("Reflection on ObjectInputStream and ObjectOutputStream classes is required for session serialization debug. Please open java.io to ALL-UNNAMED module, adding '--add-opens java.base/java.io=ALL-UNNAMED' to the JVM arguments.");
        }
        return extendedDebugInfo && canAccessJavaIO;
    }

    public static boolean isTrackingAvailable() {
        return DebugMode.isTrackingAvailable(null);
    }
}

