/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.kubernetes.starter.sessiontracker.push;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.server.communication.AtmospherePushConnection;
import com.vaadin.flow.server.communication.PushConnection;
import com.vaadin.flow.server.communication.PushConnectionFactory;
import com.vaadin.kubernetes.starter.sessiontracker.push.PushSendListener;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.atmosphere.cpr.AtmosphereResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotifyingPushConnection
extends AtmospherePushConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(NotifyingPushConnection.class);

    public NotifyingPushConnection(UI ui) {
        super(ui);
    }

    public void connect(AtmosphereResource resource) {
        super.connect(resource);
        this.notifyPushListeners(listener -> listener.onConnect(resource));
    }

    public void push(boolean async) {
        AtomicBoolean canPush = new AtomicBoolean(true);
        this.notifyPushListeners(listener -> canPush.compareAndSet(true, listener.canPush()));
        if (canPush.get()) {
            super.push(async);
        } else {
            LOGGER.debug("Push operation postponed by a PushSendListener");
        }
    }

    protected void sendMessage(String message) {
        super.sendMessage(message);
        AtmosphereResource resource = this.getResource();
        this.notifyPushListeners(listener -> listener.onMessageSent(resource));
    }

    private void notifyPushListeners(Consumer<PushSendListener> action) {
        Collection pushSendListeners = null;
        try {
            pushSendListeners = ((Lookup)this.getUI().getSession().getService().getContext().getAttribute(Lookup.class)).lookupAll(PushSendListener.class);
        }
        catch (IllegalStateException ex) {
            String message = "Cannot get PushSendListener instances. Most likely application server is shutting down and the error can be ignored.";
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(message, (Throwable)ex);
            }
            LOGGER.debug(message);
        }
        if (pushSendListeners != null) {
            pushSendListeners.forEach(action);
        }
    }

    public static class Factory
    implements PushConnectionFactory {
        public PushConnection apply(UI ui) {
            return new NotifyingPushConnection(ui);
        }
    }
}

