/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.kubernetes.starter.sessiontracker;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;

public final class SessionTrackerCookie {
    private SessionTrackerCookie() {
    }

    @Deprecated(since="2.4", forRemoval=true)
    public static void setIfNeeded(HttpSession session, HttpServletRequest request, HttpServletResponse response, Consumer<Cookie> cookieConsumer) {
        SessionTrackerCookie.setIfNeeded(session, request, response, "clusterKey", cookieConsumer);
    }

    public static void setIfNeeded(HttpSession session, HttpServletRequest request, HttpServletResponse response, String cookieName, Consumer<Cookie> cookieConsumer) {
        Optional<Cookie> clusterKeyCookie = SessionTrackerCookie.getCookie(request, cookieName = Objects.requireNonNullElse(cookieName, "clusterKey"));
        if (clusterKeyCookie.isEmpty()) {
            String clusterKey = UUID.randomUUID().toString();
            if (session != null) {
                session.setAttribute("clusterKey", (Object)clusterKey);
            }
            Cookie cookie = new Cookie(cookieName, clusterKey);
            cookieConsumer.accept(cookie);
            response.addCookie(cookie);
        } else if (session != null && session.getAttribute("clusterKey") == null) {
            String clusterKey = clusterKeyCookie.get().getValue();
            session.setAttribute("clusterKey", (Object)clusterKey);
        }
    }

    public static Optional<String> getFromSession(HttpSession session) {
        return Optional.ofNullable((String)session.getAttribute("clusterKey"));
    }

    private static Optional<Cookie> getCookie(HttpServletRequest request, String cookieName) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return Optional.empty();
        }
        return Stream.of(cookies).filter(c -> c.getName().equals(cookieName)).findFirst();
    }

    @Deprecated(since="2.4", forRemoval=true)
    public static Optional<String> getValue(HttpServletRequest request) {
        return SessionTrackerCookie.getValue(request, "clusterKey");
    }

    public static Optional<String> getValue(HttpServletRequest request, String cookieName) {
        return SessionTrackerCookie.getCookie(request, cookieName).map(Cookie::getValue);
    }
}

