/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.kubernetes.starter.ui;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tag(value="version-notifier")
@JsModule(value="./components/version-notifier.ts")
public class VersionNotifier
extends Component {
    private static final long serialVersionUID = 1L;

    VersionNotifier(String current, String update) {
        this.getElement().setProperty("currentVersion", current);
        this.getElement().setProperty("updateVersion", update);
    }

    public void addSwitchVersionEventListener(ComponentEventListener<SwitchVersionEvent> listener) {
        VersionNotifier.getLogger().debug("Adding listener for SwitchVersionEvent.");
        this.addListener(SwitchVersionEvent.class, listener);
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(VersionNotifier.class);
    }

    @DomEvent(value="load-version")
    public static class SwitchVersionEvent
    extends ComponentEvent<VersionNotifier> {
        private static final long serialVersionUID = 1L;

        public SwitchVersionEvent(VersionNotifier source, boolean fromClient) {
            super((Component)source, fromClient);
        }
    }
}

