/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.kubernetes.starter.sessiontracker.serialization.debug;

import com.vaadin.kubernetes.starter.sessiontracker.serialization.debug.Outcome;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Result
implements Serializable {
    public static final String CATEGORY_ERRORS = "ERRORS";
    private final String sessionId;
    private final String storageKey;
    private final LinkedHashSet<Outcome> outcomes;
    private final long duration;
    private final Map<String, List<String>> messages;

    Result(String sessionId, String storageKey, Set<Outcome> outcomes, long duration, Map<String, List<String>> messages) {
        this.sessionId = sessionId;
        this.storageKey = storageKey;
        this.outcomes = new LinkedHashSet<Outcome>(outcomes);
        this.duration = duration;
        this.messages = new LinkedHashMap<String, List<String>>(messages);
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getStorageKey() {
        return this.storageKey;
    }

    public Set<Outcome> getOutcomes() {
        return this.outcomes;
    }

    public long getDuration() {
        return this.duration;
    }

    public List<String> getNotSerializableClasses() {
        return new ArrayList<String>(this.messages.getOrDefault(Outcome.NOT_SERIALIZABLE_CLASSES.name(), Collections.emptyList()));
    }

    public Set<String> getSerializedLambdas() {
        return new LinkedHashSet<String>(this.messages.getOrDefault(Outcome.NOT_SERIALIZABLE_CLASSES.name(), Collections.emptyList()));
    }

    public List<String> getErrors() {
        return this.messages.getOrDefault(CATEGORY_ERRORS, Collections.emptyList());
    }
}

