/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.kubernetes.starter.sessiontracker.push;

import com.vaadin.kubernetes.starter.sessiontracker.CurrentKey;
import com.vaadin.kubernetes.starter.sessiontracker.SessionSerializer;
import com.vaadin.kubernetes.starter.sessiontracker.SessionTrackerCookie;
import com.vaadin.kubernetes.starter.sessiontracker.push.PushSendListener;
import jakarta.servlet.http.HttpSession;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushSessionTracker
implements PushSendListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(PushSessionTracker.class);
    private final SessionSerializer sessionSerializer;
    private Predicate<String> activeSessionChecker = id -> true;
    private String clusterCookieName;

    @Deprecated(forRemoval=true)
    public PushSessionTracker(SessionSerializer sessionSerializer) {
        this.sessionSerializer = sessionSerializer;
        this.clusterCookieName = "clusterKey";
    }

    public PushSessionTracker(SessionSerializer sessionSerializer, String clusterCookieName) {
        this.sessionSerializer = sessionSerializer;
        this.clusterCookieName = clusterCookieName;
    }

    public void setActiveSessionChecker(Predicate<String> activeSessionChecker) {
        this.activeSessionChecker = Objects.requireNonNull(activeSessionChecker, "session checker must not be null");
    }

    @Override
    public boolean canPush() {
        return this.sessionSerializer.isRunning();
    }

    @Override
    public void onConnect(AtmosphereResource resource) {
        AtmosphereResourceSession resourceSession = resource.getAtmosphereConfig().sessionFactory().getSession(resource);
        this.tryGetSerializationKey(resource).ifPresent(key -> resourceSession.setAttribute("clusterKey", key));
    }

    @Override
    public void onMessageSent(AtmosphereResource resource) {
        HttpSession httpSession = resource.session(false);
        if (httpSession == null) {
            LOGGER.debug("Skipping session serialization. HTTP session not available");
        } else if (!this.activeSessionChecker.test(httpSession.getId())) {
            LOGGER.debug("Skipping session serialization. HTTP session {} not active", (Object)httpSession.getId());
        } else {
            this.tryGetSerializationKey(resource).ifPresent(CurrentKey::set);
            if (CurrentKey.get() != null) {
                LOGGER.debug("Serializing session {} with key {}", (Object)httpSession.getId(), (Object)CurrentKey.get());
                try {
                    this.sessionSerializer.serialize(httpSession);
                }
                finally {
                    CurrentKey.clear();
                }
            } else {
                LOGGER.debug("Skipping session serialization. Missing serialization key.");
            }
        }
    }

    private Optional<String> tryGetSerializationKey(AtmosphereResource resource) {
        AtmosphereResourceSession resourceSession = resource.getAtmosphereConfig().sessionFactory().getSession(resource, false);
        HttpSession httpSession = resource.session(false);
        String key = null;
        if (resourceSession != null) {
            key = (String)resourceSession.getAttribute("clusterKey", String.class);
        }
        if (key == null) {
            try {
                key = SessionTrackerCookie.getValue(resource.getRequest().wrappedRequest(), this.clusterCookieName).orElse(null);
            }
            catch (Exception ex) {
                LOGGER.debug("Cannot get serialization key from request", (Throwable)ex);
            }
        }
        if (key == null && httpSession != null) {
            try {
                key = SessionTrackerCookie.getFromSession(httpSession).orElse(null);
            }
            catch (Exception ex) {
                LOGGER.debug("Cannot get serialization key from session", (Throwable)ex);
            }
        }
        return Optional.ofNullable(key);
    }
}

