/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.kubernetes.starter.sessiontracker.serialization.debug;

import com.vaadin.kubernetes.starter.sessiontracker.serialization.TransientDescriptor;
import com.vaadin.kubernetes.starter.sessiontracker.serialization.TransientHandler;
import com.vaadin.kubernetes.starter.sessiontracker.serialization.TransientInjectableObjectInputStream;
import com.vaadin.kubernetes.starter.sessiontracker.serialization.debug.DebugMode;
import com.vaadin.kubernetes.starter.sessiontracker.serialization.debug.FailingToStringReplacer;
import com.vaadin.kubernetes.starter.sessiontracker.serialization.debug.Job;
import com.vaadin.kubernetes.starter.sessiontracker.serialization.debug.Track;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

class DebugTransientHandler
implements TransientHandler,
DebugMode {
    private final Job job;
    private final IdentityHashMap<Object, Unserializable> unserializableReplacements = new IdentityHashMap();

    DebugTransientHandler(Job job) {
        this.job = job;
    }

    @Override
    public void onSerializationStart() {
        this.job.reset();
    }

    @Override
    public void inject(Object object, List<TransientDescriptor> transients) {
    }

    @Override
    public List<TransientDescriptor> inspect(Object object) {
        return Collections.emptyList();
    }

    @Override
    public Optional<Serializable> onNotSerializableFound(Object object) {
        this.job.notSerializable(object);
        Serializable replacement = this.unserializableReplacements.get(object);
        if (replacement == null) {
            replacement = NULLIFY;
        }
        return Optional.of(replacement);
    }

    @Override
    public Object onSerialize(Object object, Track track) {
        if (!(object instanceof Serializable)) {
            this.unserializableReplacements.put(object, new Unserializable(track.id, object));
        } else {
            object = FailingToStringReplacer.wrapIfNeeded((Serializable)object);
        }
        this.job.track(object, track);
        return object;
    }

    @Override
    public void onDeserialize(Class<?> type, Track track, Object object) {
        this.job.pushDeserialization(track, object);
    }

    @Override
    public Object onDeserialized(Object object, Track track) {
        this.job.popDeserialization(track, object);
        if (object instanceof Unserializable && track != null) {
            return this.resolveUnserializable(track.id);
        }
        return object;
    }

    private Object resolveUnserializable(int trackId) {
        return this.unserializableReplacements.entrySet().stream().filter(e -> ((Unserializable)e.getValue()).trackId == trackId).findFirst().map(Map.Entry::getKey).orElse(null);
    }

    private static Object tryResolveUnserializable(ObjectInputStream inputStream, Unserializable unserializable) {
        return TransientInjectableObjectInputStream.onDebugMode(inputStream, debugMode -> {
            if (debugMode instanceof DebugTransientHandler) {
                return ((DebugTransientHandler)debugMode).resolveUnserializable(unserializable.trackId);
            }
            return null;
        });
    }

    private static class Unserializable
    implements Serializable {
        private final int trackId;
        private transient Object replaced;

        public Unserializable(int trackId, Object replaced) {
            this.trackId = trackId;
            this.replaced = replaced;
        }

        private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
            is.defaultReadObject();
            this.replaced = DebugTransientHandler.tryResolveUnserializable(is, this);
        }

        private Object readResolve() {
            return this.replaced;
        }
    }
}

