/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.kubernetes.starter.sessiontracker.serialization;

import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.spring.annotation.RouteScope;
import com.vaadin.flow.spring.annotation.UIScope;
import com.vaadin.flow.spring.annotation.VaadinSessionScope;
import com.vaadin.kubernetes.starter.sessiontracker.PessimisticSerializationRequiredException;
import com.vaadin.kubernetes.starter.sessiontracker.serialization.TransientDescriptor;
import com.vaadin.kubernetes.starter.sessiontracker.serialization.TransientHandler;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class SpringTransientHandler
implements TransientHandler {
    private final ApplicationContext appCtx;

    public SpringTransientHandler(ApplicationContext appCtx) {
        this.appCtx = appCtx;
    }

    @Override
    public void inject(Object obj, List<TransientDescriptor> transients) {
        Map<Class, List<TransientDescriptor>> fieldsByClass = transients.stream().collect(Collectors.groupingBy(TransientDescriptor::getDeclaringClass));
        for (Class<?> type = obj.getClass(); type != Object.class && !fieldsByClass.isEmpty(); type = type.getSuperclass()) {
            List<TransientDescriptor> descriptors = fieldsByClass.remove(type);
            if (descriptors == null) continue;
            descriptors.forEach(descr -> this.injectField(obj, (TransientDescriptor)descr));
        }
    }

    private void injectField(Object obj, TransientDescriptor descriptor) {
        SpringTransientHandler.getLogger().debug("Injecting '{}' into transient field '{}' of type '{}'", new Object[]{descriptor.getInstanceReference(), descriptor.getName(), obj.getClass()});
        try {
            ReflectTools.setJavaFieldValue((Object)obj, (Field)descriptor.getField(), (Object)this.appCtx.getBean(descriptor.getInstanceReference()));
        }
        catch (RuntimeException ex) {
            SpringTransientHandler.getLogger().error("Failed injecting '{}' into transient field '{}' of type '{}'", new Object[]{descriptor.getInstanceReference(), descriptor.getName(), obj.getClass()});
            throw ex;
        }
    }

    @Override
    public List<TransientDescriptor> inspect(Object target) {
        List<Injectable> injectables = this.findTransientFields(target.getClass(), f -> true).stream().map(field -> this.detectBean(target, (Field)field)).filter(Objects::nonNull).toList();
        return this.createDescriptors(target, injectables);
    }

    private Injectable detectBean(Object target, Field field) {
        Object value = this.getFieldValue(target, field);
        if (value != null) {
            Class<?> valueType = value.getClass();
            SpringTransientHandler.getLogger().trace("Inspecting field {} of class {} for injected beans", (Object)field.getName(), target.getClass());
            LinkedHashSet<String> beanNames = new LinkedHashSet<String>(List.of(this.appCtx.getBeanNamesForType(valueType, true, false)));
            ArrayList vaadinScopedBeanNames = new ArrayList();
            Collections.addAll(vaadinScopedBeanNames, this.appCtx.getBeanNamesForAnnotation(VaadinSessionScope.class));
            Collections.addAll(vaadinScopedBeanNames, this.appCtx.getBeanNamesForAnnotation(UIScope.class));
            Collections.addAll(vaadinScopedBeanNames, this.appCtx.getBeanNamesForAnnotation(RouteScope.class));
            boolean vaadinScoped = beanNames.stream().anyMatch(vaadinScopedBeanNames::contains);
            if (vaadinScoped && VaadinSession.getCurrent() == null) {
                SpringTransientHandler.getLogger().warn("VaadinSession is not available when trying to inspect Vaadin scoped bean: {}.Transient fields might not be registered for deserialization.", beanNames);
                beanNames.removeIf(vaadinScopedBeanNames::contains);
            }
            return new Injectable(field, value, beanNames, vaadinScoped);
        }
        SpringTransientHandler.getLogger().trace("No bean detected for field {} of class {}, field value is null", (Object)field.getName(), target.getClass());
        return null;
    }

    private TransientDescriptor createDescriptor(Object target, Injectable injectable) {
        Field field = injectable.field;
        Object value = injectable.value;
        Class<?> valueType = value.getClass();
        TransientDescriptor transientDescriptor = injectable.beanNames.stream().map(beanName -> Map.entry(beanName, this.appCtx.getBean(beanName))).filter(e -> e.getValue() == value || this.matchesPrototype((String)e.getKey(), e.getValue(), valueType)).map(Map.Entry::getKey).findFirst().map(beanName -> new TransientDescriptor(field, (String)beanName, injectable.vaadinScoped)).orElse(null);
        if (transientDescriptor != null) {
            SpringTransientHandler.getLogger().trace("Bean {} found for field {} of class {}", new Object[]{transientDescriptor.getInstanceReference(), field.getName(), target.getClass()});
        } else {
            SpringTransientHandler.getLogger().trace("No bean detected for field {} of class {}", (Object)field.getName(), target.getClass());
        }
        return transientDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TransientDescriptor> createDescriptors(Object target, List<Injectable> injectables) {
        VaadinSession vaadinSession;
        boolean sessionLocked = false;
        if (injectables.stream().anyMatch(Injectable::vaadinScoped) && (vaadinSession = VaadinSession.getCurrent()) != null) {
            try {
                sessionLocked = vaadinSession.getLockInstance().tryLock(1L, TimeUnit.SECONDS);
                if (!sessionLocked) {
                    throw new PessimisticSerializationRequiredException("Unable to acquire VaadinSession lock to lookup Vaadin scoped beans. " + this.collectVaadinScopedCandidates(injectables));
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new PessimisticSerializationRequiredException("Unable to acquire VaadinSession lock to lookup Vaadin scoped beans. " + this.collectVaadinScopedCandidates(injectables), e);
            }
        }
        try {
            List<TransientDescriptor> list = injectables.stream().map(injectable -> this.createDescriptor(target, (Injectable)injectable)).filter(Objects::nonNull).toList();
            return list;
        }
        finally {
            if (sessionLocked) {
                VaadinSession.getCurrent().getLockInstance().unlock();
            }
        }
    }

    private String collectVaadinScopedCandidates(List<Injectable> injectables) {
        return injectables.stream().filter(Injectable::vaadinScoped).map(injectable -> String.format("[Field: %s, bean candidates: %s]", injectable.field.getName(), injectable.beanNames)).collect(Collectors.joining(", "));
    }

    private boolean matchesPrototype(String beanName, Object beanDefinition, Class<?> fieldValueType) {
        return this.appCtx.containsBeanDefinition(beanName) && this.appCtx.isPrototype(beanName) && beanDefinition.getClass() == fieldValueType;
    }

    private Object getFieldValue(Object target, Field field) {
        try {
            field.setAccessible(true);
            return field.get(target);
        }
        catch (IllegalAccessException | InaccessibleObjectException e) {
            SpringTransientHandler.getLogger().trace("Cannot access field {} of class {}", new Object[]{field.getName(), target.getClass(), e});
            return null;
        }
    }

    private List<Field> findTransientFields(Class<?> type, Predicate<Field> includeField) {
        ArrayList<Field> transientFields = new ArrayList<Field>();
        while (type != Object.class) {
            Stream.of(type.getDeclaredFields()).filter(f -> Modifier.isTransient(f.getModifiers())).filter(includeField).collect(Collectors.toCollection(() -> transientFields));
            type = type.getSuperclass();
        }
        return transientFields;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(SpringTransientHandler.class);
    }

    private record Injectable(Field field, Object value, Set<String> beanNames, boolean vaadinScoped) {
    }
}

