/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.kubernetes.starter.sessiontracker.backend;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.vaadin.kubernetes.starter.ProductUtils;
import com.vaadin.kubernetes.starter.sessiontracker.backend.BackendConnector;
import com.vaadin.kubernetes.starter.sessiontracker.backend.SessionInfo;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HazelcastConnector
implements BackendConnector {
    private final IMap<String, byte[]> sessions;

    public HazelcastConnector(HazelcastInstance hazelcastInstance) {
        HazelcastConnector.shutdownHookWarning(hazelcastInstance);
        this.sessions = hazelcastInstance.getMap("vaadin:sessions");
    }

    private static void shutdownHookWarning(HazelcastInstance hazelcastInstance) {
        HazelcastProperties properties = new HazelcastProperties(hazelcastInstance.getConfig().getProperties());
        if (properties.getBoolean(ClusterProperty.SHUTDOWNHOOK_ENABLED)) {
            HazelcastConnector.getLogger().warn("Hazelcast shutdown hook is enabled. This is not recommended for production use because Hazelcast instance might be stopped before KubernetesKit can propagate the latest session state to the cluster. Please disable the shutdown hook by setting the `hazelcast.shutdownhook.enabled` property to `false`.\n");
        }
    }

    @Override
    public void sendSession(SessionInfo sessionInfo) {
        HazelcastConnector.getLogger().debug("Sending session {} to Hazelcast", (Object)sessionInfo.getClusterKey());
        String mapKey = HazelcastConnector.getKey(sessionInfo.getClusterKey());
        Duration timeToLive = sessionInfo.getTimeToLive();
        if (timeToLive.isZero() || timeToLive.isNegative()) {
            this.sessions.put((Object)mapKey, (Object)sessionInfo.getData());
        } else {
            this.sessions.put((Object)mapKey, (Object)sessionInfo.getData(), timeToLive.toSeconds(), TimeUnit.SECONDS);
        }
        HazelcastConnector.getLogger().debug("Session {} sent to Hazelcast", (Object)sessionInfo.getClusterKey());
    }

    @Override
    public SessionInfo getSession(String clusterKey) {
        HazelcastConnector.getLogger().debug("Requesting session for {}", (Object)clusterKey);
        this.waitForSerializationCompletion(clusterKey, "getting session");
        byte[] data = (byte[])this.sessions.get((Object)HazelcastConnector.getKey(clusterKey));
        if (data == null) {
            HazelcastConnector.getLogger().debug("Session not found {}", (Object)clusterKey);
            return null;
        }
        SessionInfo sessionInfo = new SessionInfo(clusterKey, data);
        HazelcastConnector.getLogger().debug("Received {}", (Object)sessionInfo);
        return sessionInfo;
    }

    @Override
    public void markSerializationStarted(String clusterKey, Duration timeToLive) {
        HazelcastConnector.getLogger().debug("Marking serialization started for {}", (Object)clusterKey);
        String pendingKey = HazelcastConnector.getPendingKey(clusterKey);
        this.lockPendingKey(timeToLive, pendingKey);
    }

    @Override
    public void markSerializationComplete(String clusterKey) {
        HazelcastConnector.getLogger().debug("Marking serialization complete for {}", (Object)clusterKey);
        this.sessions.forceUnlock((Object)HazelcastConnector.getPendingKey(clusterKey));
    }

    @Override
    public void markSerializationFailed(String clusterKey, Throwable error) {
        HazelcastConnector.getLogger().debug("Marking serialization failed for {}", (Object)clusterKey, (Object)error);
        this.sessions.forceUnlock((Object)HazelcastConnector.getPendingKey(clusterKey));
    }

    @Override
    public boolean markDeserializationStarted(String clusterKey, Duration timeToLive) {
        String pendingKey = HazelcastConnector.getDeserializationPendingKey(clusterKey);
        if (this.sessions.isLocked((Object)pendingKey)) {
            return false;
        }
        this.lockPendingKey(timeToLive, pendingKey);
        return true;
    }

    @Override
    public void markDeserializationComplete(String clusterKey) {
        HazelcastConnector.getLogger().debug("Marking deserialization complete for {}", (Object)clusterKey);
        this.sessions.forceUnlock((Object)HazelcastConnector.getDeserializationPendingKey(clusterKey));
    }

    @Override
    public void markDeserializationFailed(String clusterKey, Throwable error) {
        HazelcastConnector.getLogger().debug("Marking deserialization failed for {}", (Object)clusterKey, (Object)error);
        this.sessions.forceUnlock((Object)HazelcastConnector.getDeserializationPendingKey(clusterKey));
    }

    @Override
    public void deleteSession(String clusterKey) {
        HazelcastConnector.getLogger().debug("Deleting session {}", (Object)clusterKey);
        this.waitForSerializationCompletion(clusterKey, "deleting");
        this.sessions.delete((Object)HazelcastConnector.getKey(clusterKey));
        this.sessions.delete((Object)HazelcastConnector.getPendingKey(clusterKey));
        HazelcastConnector.getLogger().debug("Session {} deleted", (Object)clusterKey);
    }

    private void lockPendingKey(Duration timeToLive, String pendingKey) {
        if (timeToLive.isZero() || timeToLive.isNegative()) {
            this.sessions.lock((Object)pendingKey);
        } else {
            this.sessions.lock((Object)pendingKey, timeToLive.toSeconds(), TimeUnit.SECONDS);
        }
    }

    private void waitForSerializationCompletion(String clusterKey, String action) {
        String pendingKey = HazelcastConnector.getPendingKey(clusterKey);
        if (this.sessions.isLocked((Object)pendingKey)) {
            HazelcastConnector.getLogger().debug("Waiting for session to be serialized before {} {}", (Object)action, (Object)clusterKey);
            try {
                this.sessions.tryLock((Object)pendingKey, 5L, TimeUnit.SECONDS, 1L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ex) {
                HazelcastConnector.getLogger().warn("Gave up waiting for the serialization result of {} before {}. The host probably crashed during serialization", (Object)clusterKey, (Object)action);
            }
        }
    }

    static String getKey(String clusterKey) {
        return "session-" + clusterKey;
    }

    static String getPendingKey(String clusterKey) {
        return "pending-" + clusterKey;
    }

    static String getDeserializationPendingKey(String clusterKey) {
        return "pending-deserialization-" + clusterKey;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(HazelcastConnector.class);
    }

    static {
        ProductUtils.markAsUsed(HazelcastConnector.class.getSimpleName());
    }
}

