/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.kubernetes.starter.sessiontracker.serialization.debug;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableRunnable;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.RequestHandler;
import com.vaadin.flow.server.ServiceInitEvent;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServiceInitListener;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.WrappedHttpSession;
import com.vaadin.flow.server.WrappedSession;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import com.vaadin.kubernetes.starter.SerializationProperties;
import com.vaadin.kubernetes.starter.sessiontracker.SessionSerializationCallback;
import com.vaadin.kubernetes.starter.sessiontracker.SessionSerializer;
import com.vaadin.kubernetes.starter.sessiontracker.backend.BackendConnector;
import com.vaadin.kubernetes.starter.sessiontracker.backend.SessionExpirationPolicy;
import com.vaadin.kubernetes.starter.sessiontracker.backend.SessionInfo;
import com.vaadin.kubernetes.starter.sessiontracker.serialization.SerializationStreamFactory;
import com.vaadin.kubernetes.starter.sessiontracker.serialization.TransientInjectableObjectStreamFactory;
import com.vaadin.kubernetes.starter.sessiontracker.serialization.debug.DebugBackendConnector;
import com.vaadin.kubernetes.starter.sessiontracker.serialization.debug.DebugMode;
import com.vaadin.kubernetes.starter.sessiontracker.serialization.debug.Job;
import com.vaadin.kubernetes.starter.sessiontracker.serialization.debug.Result;
import com.vaadin.kubernetes.starter.ui.SessionDebugNotifier;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;

public class SerializationDebugRequestHandler
implements RequestHandler,
ApplicationListener<ContextClosedEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerializationDebugRequestHandler.class);
    public static final String SERIALIZATION_TEST_REQUEST_ATTRIBUTE_KEY = SerializationDebugRequestHandler.class.getName() + ".RESULT";
    private static final String SERIALIZATION_TIMEOUT_PROPERTY = "vaadin.serialization.timeout";
    private final SerializationProperties serializationProperties;
    private final DebugBackendConnector debugBackendConnector;
    private final SessionSerializer sessionSerializer;

    public SerializationDebugRequestHandler(SerializationProperties serializationProperties) {
        this.serializationProperties = serializationProperties;
        this.debugBackendConnector = new DebugBackendConnector();
        this.sessionSerializer = new SessionSerializer((BackendConnector)this.debugBackendConnector, this.debugBackendConnector, SessionExpirationPolicy.NEVER, SessionSerializationCallback.DEFAULT, (SerializationStreamFactory)new TransientInjectableObjectStreamFactory(), serializationProperties);
    }

    public void onApplicationEvent(ContextClosedEvent event) {
        this.debugBackendConnector.shutdown();
        this.sessionSerializer.stop();
    }

    public boolean handleRequest(VaadinSession vaadinSession, VaadinRequest vaadinRequest, VaadinResponse vaadinResponse) {
        ApplicationConfiguration appConfiguration = ApplicationConfiguration.get((VaadinContext)vaadinSession.getService().getContext());
        if (appConfiguration.isProductionMode()) {
            LoggerFactory.getLogger(InitListener.class).warn("SerializationDebugRequestHandler in not enabled in production mode");
            return false;
        }
        if (!appConfiguration.isDevModeSessionSerializationEnabled()) {
            LoggerFactory.getLogger(InitListener.class).warn("SerializationDebugRequestHandler is enabled only with enable session serialization setting 'vaadin.devmode.sessionSerialization.enabled=true'");
            return false;
        }
        if (HandlerHelper.isRequestType((VaadinRequest)vaadinRequest, (HandlerHelper.RequestType)HandlerHelper.RequestType.UIDL)) {
            try {
                VaadinService vaadinService = vaadinSession.getService();
                vaadinSession.accessSynchronously((Command & Serializable)() -> {
                    SerializableConsumer onComplete = null;
                    UI ui = vaadinService.findUI(vaadinRequest);
                    if (ui != null) {
                        boolean pushEnabled = ui.getPushConfiguration().getPushMode().isEnabled();
                        SessionDebugNotifier debugNotifier = ui.getChildren().filter(SessionDebugNotifier.class::isInstance).map(SessionDebugNotifier.class::cast).findAny().orElseGet(() -> {
                            SessionDebugNotifier notifier = new SessionDebugNotifier();
                            ui.add(new Component[]{notifier});
                            return notifier;
                        });
                        if (pushEnabled) {
                            onComplete = ui.accessLater(debugNotifier::publishResults, (SerializableRunnable & Serializable)() -> {});
                        }
                    }
                    int serializationTimeout = this.getSerializationTimeout(this.serializationProperties);
                    vaadinRequest.setAttribute(SERIALIZATION_TEST_REQUEST_ATTRIBUTE_KEY, (Object)new Runner((Consumer<Result>)onComplete, serializationTimeout));
                });
            }
            catch (Exception ex) {
                LOGGER.debug("Error during serialization debug", (Throwable)ex);
            }
        }
        return false;
    }

    @Deprecated(forRemoval=true)
    public static void serializeAndDeserialize(WrappedSession session, Consumer<Result> onComplete, int serializationTimeout) {
        new SerializationDebugRequestHandler(new SerializationProperties()).internalSerializeAndDeserialize(session, onComplete, serializationTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalSerializeAndDeserialize(WrappedSession session, Consumer<Result> onComplete, int serializationTimeout) {
        DebugHttpSession debugHttpSession = new DebugHttpSession(session);
        String clusterKey = debugHttpSession.getClusterKey();
        Optional<Job> maybeJob = this.debugBackendConnector.newJob(session.getId(), clusterKey);
        if (maybeJob.isEmpty()) {
            LOGGER.debug("A serialization test for session {} is already in progress, rejecting request.", (Object)session.getId());
            return;
        }
        Job job = maybeJob.get();
        try {
            SerializationDebugRequestHandler.trySerialize(this.sessionSerializer, debugHttpSession, job);
            SessionInfo info = this.debugBackendConnector.waitForCompletion(job, serializationTimeout, LOGGER);
            if (info != null) {
                debugHttpSession = new DebugHttpSession("DEBUG-DESERIALIZE-" + session.getId());
                SerializationDebugRequestHandler.tryDeserialize(this.sessionSerializer, info, debugHttpSession, job);
            }
        }
        finally {
            List<String> notSerializableClasses;
            Result result = job.complete();
            this.debugBackendConnector.deleteSession(clusterKey);
            StringBuilder message = new StringBuilder("Session serialization attempt finished in ").append(result.getDuration()).append(" ms with outcomes: ").append(result.getOutcomes());
            List<String> errors = result.getErrors();
            if (!errors.isEmpty()) {
                message.append(System.lineSeparator()).append(System.lineSeparator()).append("ERRORS DURING SERIALIZATION/DESERIALIZATION PROCESS:").append(System.lineSeparator()).append("====================================================").append(System.lineSeparator()).append(String.join((CharSequence)(System.lineSeparator() + System.lineSeparator()), errors));
            }
            if (!(notSerializableClasses = result.getNotSerializableClasses()).isEmpty()) {
                message.append(System.lineSeparator()).append(System.lineSeparator()).append("NOT SERIALIZABLE CLASSES FOUND:").append(System.lineSeparator()).append("===============================").append(System.lineSeparator()).append(System.lineSeparator()).append(String.join((CharSequence)System.lineSeparator(), notSerializableClasses));
            }
            LOGGER.info(message.toString());
            onComplete.accept(result);
            System.gc();
        }
    }

    private int getSerializationTimeout(SerializationProperties properties) {
        int timeout = 30000;
        if (properties != null && properties.getTimeout() > 0) {
            timeout = properties.getTimeout();
        } else {
            String timeoutStr = System.getProperty(SERIALIZATION_TIMEOUT_PROPERTY);
            if (timeoutStr != null) {
                timeout = Integer.parseInt(timeoutStr);
            }
        }
        return timeout;
    }

    private static void trySerialize(SessionSerializer serializer, HttpSession session, Job job) {
        try {
            serializer.serialize(session);
        }
        catch (Exception e) {
            job.serializationFailed(e);
            LOGGER.error("Test session serialization failed", (Throwable)e);
        }
    }

    private static void tryDeserialize(SessionSerializer serializer, SessionInfo info, HttpSession debugHttpSession, Job job) {
        try {
            job.deserializationStarted();
            serializer.deserialize(info, debugHttpSession);
            job.deserialized();
        }
        catch (Exception e) {
            job.deserializationFailed(e);
            LOGGER.error("Test session deserialization failed", (Throwable)e);
        }
    }

    public static class InitListener
    implements VaadinServiceInitListener {
        public SerializationProperties serializationProperties;

        public InitListener() {
        }

        public InitListener(SerializationProperties serializationProperties) {
            this.serializationProperties = serializationProperties;
        }

        public void serviceInit(ServiceInitEvent serviceInitEvent) {
            ApplicationConfiguration appConfiguration = ApplicationConfiguration.get((VaadinContext)serviceInitEvent.getSource().getContext());
            Logger logger = LoggerFactory.getLogger(InitListener.class);
            if (appConfiguration.isProductionMode()) {
                logger.warn("SerializationDebugRequestHandler cannot be installed in production mode");
            } else if (!appConfiguration.isDevModeSessionSerializationEnabled()) {
                logger.warn("To install SerializationDebugRequestHandler enable session serialization setting 'vaadin.devmode.sessionSerialization.enabled=true'");
            } else if (!DebugMode.isTrackingAvailable(logger)) {
                logger.warn("SerializationDebugRequestHandler cannot be installed if above preconditions are not met");
            } else {
                logger.info("Installing SerializationDebugRequestHandler for session serialization debug");
                serviceInitEvent.addRequestHandler((RequestHandler)new SerializationDebugRequestHandler(this.serializationProperties));
            }
        }
    }

    private static class DebugHttpSession
    implements HttpSession {
        private final Map<String, Object> storage = new HashMap<String, Object>();
        private final String sessionId;

        DebugHttpSession(String sessionId) {
            this.sessionId = sessionId;
        }

        DebugHttpSession(WrappedSession source) {
            this.sessionId = "DEBUG-SERIALIZE-" + source.getId();
            source.getAttributeNames().forEach(key -> this.storage.put((String)key, source.getAttribute(key)));
            this.storage.put("clusterKey", String.valueOf(UUID.randomUUID()) + "_SOURCE:" + source.getId());
        }

        String getClusterKey() {
            return (String)this.storage.get("clusterKey");
        }

        public long getCreationTime() {
            return 0L;
        }

        public String getId() {
            return this.sessionId;
        }

        public long getLastAccessedTime() {
            return 0L;
        }

        public ServletContext getServletContext() {
            return null;
        }

        public void setMaxInactiveInterval(int interval) {
        }

        public int getMaxInactiveInterval() {
            return 0;
        }

        public Object getAttribute(String name) {
            return this.storage.get(name);
        }

        public Enumeration<String> getAttributeNames() {
            return Collections.enumeration(this.storage.keySet());
        }

        public void setAttribute(String name, Object value) {
            this.storage.put(name, value);
        }

        public void removeAttribute(String name) {
            this.storage.remove(name);
        }

        public void invalidate() {
        }

        public boolean isNew() {
            return false;
        }
    }

    class Runner
    implements Consumer<HttpServletRequest> {
        private final Consumer<Result> onComplete;
        private final int serializationTimeout;

        private Runner(Consumer<Result> onComplete, int serializationTimeout) {
            this.onComplete = onComplete;
            this.serializationTimeout = serializationTimeout;
        }

        private void executeOnComplete(Result result) {
            if (this.onComplete != null) {
                try {
                    this.onComplete.accept(result);
                }
                catch (Exception ex) {
                    LoggerFactory.getLogger(Runner.class).error("Error during executing on complete task", (Throwable)ex);
                }
            }
        }

        @Override
        public void accept(HttpServletRequest request) {
            HttpSession session = request.getSession(false);
            if (session != null && request.isRequestedSessionIdValid()) {
                SerializationDebugRequestHandler.this.internalSerializeAndDeserialize((WrappedSession)new WrappedHttpSession(session), this::executeOnComplete, this.serializationTimeout);
            }
        }
    }

    public static class Filter
    extends HttpFilter {
        private static final Logger LOGGER = LoggerFactory.getLogger(Filter.class);

        protected void doFilter(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
            Object action = req.getAttribute(SERIALIZATION_TEST_REQUEST_ATTRIBUTE_KEY);
            if (action instanceof Runner) {
                LOGGER.debug("Vaadin request processed, running Session Serialization Debug Tool");
                ((Runner)action).accept(req);
            }
        }
    }
}

