/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.kubernetes.starter;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(prefix="vaadin.serialization")
public class SerializationProperties {
    public static final String PREFIX = "vaadin.serialization";
    public static final int DEFAULT_SERIALIZATION_TIMEOUT_MS = 30000;
    public static final int DEFAULT_DESERIALIZATION_LOCK_TIMEOUT_MS = 10000;
    public static final int DEFAULT_OPTIMISTIC_SERIALIZATION_TIMEOUT_MS = 30000;
    public static final int DEFAULT_OPTIMISTIC_SERIALIZATION_DELAY_MS = 10;
    private int timeout = 30000;
    private int deserializationLockTimeout = 10000;
    private int optimisticTimeout = 30000;
    private int optimisticDelay = 10;
    @NestedConfigurationProperty
    private final TransientsProperties transients = new TransientsProperties();

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getDeserializationLockTimeout() {
        return this.deserializationLockTimeout;
    }

    public void setDeserializationLockTimeout(int timeout) {
        this.deserializationLockTimeout = timeout;
    }

    public int getOptimisticTimeout() {
        return this.optimisticTimeout;
    }

    public void setOptimisticTimeout(int optimisticTimeout) {
        this.optimisticTimeout = optimisticTimeout;
    }

    public int getOptimisticDelay() {
        return this.optimisticDelay;
    }

    public void setOptimisticDelay(int delay) {
        this.optimisticDelay = delay;
    }

    public TransientsProperties getTransients() {
        return this.transients;
    }

    static class TransientsProperties {
        private final Set<String> includePackages = new HashSet<String>();
        private final Set<String> excludePackages = new HashSet<String>();

        TransientsProperties() {
        }

        public Set<String> getIncludePackages() {
            return this.includePackages;
        }

        public Set<String> getExcludePackages() {
            return this.excludePackages;
        }

        public Predicate<Class<?>> transientInjectableFilter() {
            if (this.includePackages.isEmpty() && this.excludePackages.isEmpty()) {
                return type -> true;
            }
            return type -> {
                String packageName = type.getPackageName();
                if (!this.excludePackages.stream().noneMatch(packageName::startsWith)) return false;
                if (this.includePackages.isEmpty()) return true;
                if (!this.includePackages.stream().anyMatch(packageName::startsWith)) return false;
                return true;
            };
        }
    }
}

