/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.kubernetes.starter.sessiontracker.serialization.debug;

import com.vaadin.kubernetes.starter.sessiontracker.backend.BackendConnector;
import com.vaadin.kubernetes.starter.sessiontracker.backend.SessionInfo;
import com.vaadin.kubernetes.starter.sessiontracker.serialization.TransientHandler;
import com.vaadin.kubernetes.starter.sessiontracker.serialization.debug.DebugTransientHandler;
import com.vaadin.kubernetes.starter.sessiontracker.serialization.debug.Job;
import java.time.Duration;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import org.slf4j.Logger;

class DebugBackendConnector
implements BackendConnector,
BiFunction<String, String, TransientHandler> {
    private final Map<String, Job> jobs = new ConcurrentHashMap<String, Job>();
    private final Map<String, SessionInfo> serializedSessions = new ConcurrentHashMap<String, SessionInfo>();
    private final Map<Job, DebugTransientHandler> handlers = new IdentityHashMap<Job, DebugTransientHandler>();

    DebugBackendConnector() {
    }

    @Override
    public void sendSession(SessionInfo sessionInfo) {
        if (sessionInfo != null) {
            this.serializedSessions.put(sessionInfo.getClusterKey(), sessionInfo);
        }
    }

    @Override
    public SessionInfo getSession(String clusterKey) {
        this.getJob(clusterKey);
        return this.serializedSessions.get(clusterKey);
    }

    @Override
    public void deleteSession(String clusterKey) {
        this.serializedSessions.remove(clusterKey);
        Job job = this.jobs.remove(clusterKey);
        if (job != null) {
            job.reset();
            this.handlers.remove(job);
        }
    }

    @Override
    public void markSerializationStarted(String clusterKey, Duration timeToLive) {
        this.getJob(clusterKey).serializationStarted();
    }

    @Override
    public void markSerializationComplete(String clusterKey) {
        Job job = this.getJob(clusterKey);
        job.serialized(this.serializedSessions.get(clusterKey));
    }

    @Override
    public void markSerializationFailed(String clusterKey, Throwable error) {
        Job job = this.getJob(clusterKey);
        job.serializationFailed(new Exception(error));
    }

    @Override
    public TransientHandler apply(String sessionId, String clusterKey) {
        return this.handlers.computeIfAbsent(this.getJob(clusterKey), DebugTransientHandler::new);
    }

    synchronized Optional<Job> newJob(String sessionId, String clusterKey) {
        if (!this.jobs.containsKey(clusterKey) && this.jobs.values().stream().noneMatch(j -> j.isRunning(sessionId))) {
            Job job = new Job(sessionId, clusterKey);
            this.jobs.put(clusterKey, job);
            return Optional.of(job);
        }
        return Optional.empty();
    }

    void shutdown() {
        this.jobs.values().forEach(Job::cancel);
    }

    private Job getJob(String clusterKey) {
        Job job = this.jobs.get(clusterKey);
        if (job == null) {
            throw new IllegalStateException("No job started for clusterKey " + clusterKey);
        }
        return job;
    }

    SessionInfo waitForCompletion(Job job, int timeout, Logger logger) {
        job.waitForSerializationCompletion(timeout, logger);
        String clusterKey = this.jobs.entrySet().stream().filter(e -> job == e.getValue()).map(Map.Entry::getKey).findFirst().orElseThrow(() -> new IllegalStateException("Job is not active"));
        return this.serializedSessions.get(clusterKey);
    }
}

