/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.kubernetes.starter.sessiontracker.serialization;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.kubernetes.starter.sessiontracker.SessionUtil;
import com.vaadin.kubernetes.starter.sessiontracker.serialization.TransientDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

final class TransientAwareHolder
implements Serializable {
    static final TransientAwareHolder NULL = new TransientAwareHolder(null, Collections.emptyList());
    private final List<TransientDescriptor> transientDescriptors;
    private final Object source;
    private final UI ui;
    private final VaadinSession session;

    TransientAwareHolder(Object source, List<TransientDescriptor> descriptors) {
        this.source = source;
        this.transientDescriptors = new ArrayList<TransientDescriptor>(descriptors);
        if (descriptors.stream().anyMatch(TransientDescriptor::isVaadinScoped)) {
            this.ui = UI.getCurrent();
            this.session = this.ui != null ? this.ui.getSession() : VaadinSession.getCurrent();
        } else {
            this.ui = null;
            this.session = null;
        }
    }

    List<TransientDescriptor> transients() {
        return new ArrayList<TransientDescriptor>(this.transientDescriptors);
    }

    Object source() {
        return this.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void inVaadinScope(Runnable runnable) {
        Map instanceMap = null;
        if (this.ui != null) {
            instanceMap = CurrentInstance.setCurrent((UI)this.ui);
        } else if (this.session != null) {
            instanceMap = CurrentInstance.setCurrent((VaadinSession)this.session);
        }
        Runnable cleaner = SessionUtil.injectLockIfNeeded(this.session);
        try {
            runnable.run();
        }
        finally {
            if (instanceMap != null) {
                CurrentInstance.clearAll();
                CurrentInstance.restoreInstances((Map)instanceMap);
                cleaner.run();
            }
        }
    }
}

