/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.kubernetes.starter.sessiontracker.push;

import com.vaadin.kubernetes.starter.sessiontracker.CurrentKey;
import com.vaadin.kubernetes.starter.sessiontracker.SessionSerializer;
import com.vaadin.kubernetes.starter.sessiontracker.SessionTrackerCookie;
import com.vaadin.kubernetes.starter.sessiontracker.push.PushSendListener;
import jakarta.servlet.http.HttpSession;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushSessionTracker
implements PushSendListener {
    private final SessionSerializer sessionSerializer;
    private Predicate<String> activeSessionChecker = id -> true;
    private String clusterCookieName;

    @Deprecated(forRemoval=true)
    public PushSessionTracker(SessionSerializer sessionSerializer) {
        this.sessionSerializer = sessionSerializer;
        this.clusterCookieName = "clusterKey";
    }

    public PushSessionTracker(SessionSerializer sessionSerializer, String clusterCookieName) {
        this.sessionSerializer = sessionSerializer;
        this.clusterCookieName = clusterCookieName;
    }

    public void setActiveSessionChecker(Predicate<String> activeSessionChecker) {
        this.activeSessionChecker = Objects.requireNonNull(activeSessionChecker, "session checker must not be null");
    }

    @Override
    public void onConnect(AtmosphereResource resource) {
        AtmosphereResourceSession resourceSession = resource.getAtmosphereConfig().sessionFactory().getSession(resource);
        this.tryGetSerializationKey(resource).ifPresent(key -> resourceSession.setAttribute("clusterKey", key));
    }

    @Override
    public void onMessageSent(AtmosphereResource resource) {
        HttpSession httpSession = resource.session(false);
        if (httpSession != null && this.activeSessionChecker.test(httpSession.getId())) {
            this.tryGetSerializationKey(resource).ifPresent(CurrentKey::set);
            if (CurrentKey.get() != null) {
                this.getLogger().debug("Serializing session {} with key {}", (Object)httpSession.getId(), (Object)CurrentKey.get());
                try {
                    this.sessionSerializer.serialize(httpSession);
                }
                finally {
                    CurrentKey.clear();
                }
            } else {
                this.getLogger().debug("Skipping session serialization. Missing serialization key.");
            }
        } else {
            this.getLogger().debug("Skipping session serialization. Session not available");
        }
    }

    private Optional<String> tryGetSerializationKey(AtmosphereResource resource) {
        AtmosphereResourceSession resourceSession = resource.getAtmosphereConfig().sessionFactory().getSession(resource, false);
        HttpSession httpSession = resource.session(false);
        String key = null;
        if (resourceSession != null) {
            key = (String)resourceSession.getAttribute("clusterKey", String.class);
        }
        if (key == null) {
            try {
                key = SessionTrackerCookie.getValue(resource.getRequest().wrappedRequest(), this.clusterCookieName).orElse(null);
            }
            catch (Exception ex) {
                this.getLogger().debug("Cannot get serialization key from request", (Throwable)ex);
            }
        }
        if (key == null && httpSession != null) {
            try {
                key = SessionTrackerCookie.getFromSession(httpSession).orElse(null);
            }
            catch (Exception ex) {
                this.getLogger().debug("Cannot get serialization key from session", (Throwable)ex);
            }
        }
        return Optional.ofNullable(key);
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

