/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.kubernetes.starter.sessiontracker.push;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.server.communication.AtmospherePushConnection;
import com.vaadin.flow.server.communication.PushConnection;
import com.vaadin.flow.server.communication.PushConnectionFactory;
import com.vaadin.kubernetes.starter.sessiontracker.push.PushSendListener;
import java.util.function.Consumer;
import org.atmosphere.cpr.AtmosphereResource;

public class NotifyingPushConnection
extends AtmospherePushConnection {
    public NotifyingPushConnection(UI ui) {
        super(ui);
    }

    public void connect(AtmosphereResource resource) {
        super.connect(resource);
        this.notifyPushListeners(listener -> listener.onConnect(resource));
    }

    protected void sendMessage(String message) {
        super.sendMessage(message);
        AtmosphereResource resource = this.getResource();
        this.notifyPushListeners(listener -> listener.onMessageSent(resource));
    }

    private void notifyPushListeners(Consumer<PushSendListener> action) {
        ((Lookup)this.getUI().getSession().getService().getContext().getAttribute(Lookup.class)).lookupAll(PushSendListener.class).forEach(action);
    }

    public static class Factory
    implements PushConnectionFactory {
        public PushConnection apply(UI ui) {
            return new NotifyingPushConnection(ui);
        }
    }
}

