/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.kubernetes.starter.sessiontracker.backend;

import com.vaadin.kubernetes.starter.ProductUtils;
import com.vaadin.kubernetes.starter.sessiontracker.backend.BackendConnector;
import com.vaadin.kubernetes.starter.sessiontracker.backend.BackendUtil;
import com.vaadin.kubernetes.starter.sessiontracker.backend.SessionInfo;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.core.types.Expiration;

public class RedisConnector
implements BackendConnector {
    private final RedisConnectionFactory redisConnectionFactory;

    public RedisConnector(RedisConnectionFactory redisConnectionFactory) {
        this.redisConnectionFactory = redisConnectionFactory;
    }

    @Override
    public void sendSession(SessionInfo sessionInfo) {
        RedisConnector.getLogger().debug("Sending session {} to Redis", (Object)sessionInfo.getClusterKey());
        try (RedisConnection connection = this.redisConnectionFactory.getConnection();){
            byte[] key = RedisConnector.getKey(sessionInfo.getClusterKey());
            Duration timeToLive = sessionInfo.getTimeToLive();
            if (timeToLive.isZero() || timeToLive.isNegative()) {
                connection.stringCommands().set(key, sessionInfo.getData());
            } else {
                connection.stringCommands().set(key, sessionInfo.getData(), Expiration.from((Duration)timeToLive), RedisStringCommands.SetOption.UPSERT);
            }
            RedisConnector.getLogger().debug("Session {} sent to Redis", (Object)sessionInfo.getClusterKey());
        }
    }

    static byte[] getKey(String clusterKey) {
        return BackendUtil.b("session-" + clusterKey);
    }

    @Override
    public SessionInfo getSession(String clusterKey) {
        RedisConnector.getLogger().debug("Requesting session for {}", (Object)clusterKey);
        try (RedisConnection connection = this.redisConnectionFactory.getConnection();){
            this.waitForSerializationCompletion(clusterKey, "getting session", connection);
            byte[] data = connection.stringCommands().get(RedisConnector.getKey(clusterKey));
            if (data == null) {
                SessionInfo sessionInfo = null;
                return sessionInfo;
            }
            SessionInfo sessionInfo = new SessionInfo(clusterKey, data);
            RedisConnector.getLogger().debug("Received {}", (Object)sessionInfo);
            SessionInfo sessionInfo2 = sessionInfo;
            return sessionInfo2;
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(RedisConnector.class);
    }

    @Override
    public void markSerializationStarted(String clusterKey, Duration timeToLive) {
        RedisConnector.getLogger().debug("Marking serialization started for {}", (Object)clusterKey);
        try (RedisConnection connection = this.redisConnectionFactory.getConnection();){
            if (timeToLive.isZero() || timeToLive.isNegative()) {
                connection.stringCommands().set(RedisConnector.getPendingKey(clusterKey), BackendUtil.b("" + System.currentTimeMillis()));
            } else {
                connection.stringCommands().set(RedisConnector.getPendingKey(clusterKey), BackendUtil.b("" + System.currentTimeMillis()), Expiration.from((Duration)timeToLive), RedisStringCommands.SetOption.UPSERT);
            }
        }
    }

    @Override
    public void markSerializationComplete(String clusterKey) {
        RedisConnector.getLogger().debug("Marking serialization complete for {}", (Object)clusterKey);
        try (RedisConnection connection = this.redisConnectionFactory.getConnection();){
            connection.keyCommands().del((byte[][])new byte[][]{RedisConnector.getPendingKey(clusterKey)});
        }
    }

    @Override
    public void markSerializationFailed(String clusterKey, Throwable error) {
        RedisConnector.getLogger().debug("Marking serialization failed for {}", (Object)clusterKey, (Object)error);
        try (RedisConnection connection = this.redisConnectionFactory.getConnection();){
            connection.keyCommands().del((byte[][])new byte[][]{RedisConnector.getPendingKey(clusterKey)});
        }
    }

    @Override
    public void deleteSession(String clusterKey) {
        RedisConnector.getLogger().debug("Deleting session for {}", (Object)clusterKey);
        try (RedisConnection connection = this.redisConnectionFactory.getConnection();){
            this.waitForSerializationCompletion(clusterKey, "deleting session", connection);
            connection.keyCommands().del((byte[][])new byte[][]{RedisConnector.getKey(clusterKey)});
            connection.keyCommands().del((byte[][])new byte[][]{RedisConnector.getPendingKey(clusterKey)});
        }
    }

    static byte[] getPendingKey(String clusterKey) {
        return BackendUtil.b("pending-" + clusterKey);
    }

    private void waitForSerializationCompletion(String clusterKey, String action, RedisConnection connection) {
        byte[] pendingKey = RedisConnector.getPendingKey(clusterKey);
        if (Boolean.TRUE.equals(connection.keyCommands().exists(pendingKey))) {
            long timeout = System.currentTimeMillis() + 5000L;
            RedisConnector.getLogger().debug("Waiting for session to be serialized before {} {}", (Object)action, (Object)clusterKey);
            while (Boolean.TRUE.equals(connection.keyCommands().exists(pendingKey)) && System.currentTimeMillis() < timeout) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (System.currentTimeMillis() > timeout) {
                RedisConnector.getLogger().warn("Gave up waiting for the serialization result of {} before {}. The host probably crashed during serialization", (Object)clusterKey, (Object)action);
            }
        }
    }

    static {
        ProductUtils.markAsUsed(RedisConnector.class.getSimpleName());
    }
}

