/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.kubernetes.starter.sessiontracker;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementUtil;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.internal.NodeOwner;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.kubernetes.starter.sessiontracker.SessionUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

@Tag(value="div")
public class UnserializableComponentWrapper<S extends Serializable, T extends Component>
extends Component {
    private transient T component;
    private S state;
    private final SerializableFunction<T, S> serializer;
    private final SerializableFunction<S, T> deserializer;

    public UnserializableComponentWrapper(T component, SerializableFunction<T, S> serializer, SerializableFunction<S, T> deserializer) {
        this.component = (Component)Objects.requireNonNull(component, "component cannot be null");
        this.serializer = Objects.requireNonNull(serializer, "serializer function cannot be null");
        this.deserializer = Objects.requireNonNull(deserializer, "deserializer function cannot be null");
        this.getElement().appendChild(new Element[]{component.getElement()});
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.state = (Serializable)this.serializer.apply(this.component);
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        in.registerValidation(this::restoreComponent, 0);
    }

    private void restoreComponent() {
        this.getUI().ifPresent(ui -> {
            VaadinSession session = ui.getSession();
            Map instances = CurrentInstance.getInstances();
            CurrentInstance.set(UI.class, (Object)ui);
            CurrentInstance.set(VaadinSession.class, (Object)session);
            Runnable cleaner = SessionUtil.injectLockIfNeeded(session);
            try {
                this.getElement().removeAllChildren();
                if (this.state != null) {
                    this.component = (Component)this.deserializer.apply(this.state);
                    this.state = null;
                    this.getElement().appendChild(new Element[]{this.component.getElement()});
                }
            }
            finally {
                CurrentInstance.clearAll();
                CurrentInstance.restoreInstances((Map)instances);
                cleaner.run();
            }
        });
    }

    static void beforeSerialization(UI ui) {
        UnserializableComponentWrapper.doWithWrapper(ui, UnserializableComponentWrapper::beforeSerialization);
    }

    public static void beforeSerialization(UnserializableComponentWrapper<?, ?> wrapper) {
        wrapper.component.removeFromParent();
        UnserializableComponentWrapper.flush(wrapper);
    }

    static void afterSerialization(UI ui) {
        UnserializableComponentWrapper.doWithWrapper(ui, UnserializableComponentWrapper::afterSerialization);
    }

    public static void afterSerialization(UnserializableComponentWrapper<?, ?> wrapper) {
        wrapper.state = null;
        wrapper.getElement().appendChild(new Element[]{wrapper.component.getElement()});
        UnserializableComponentWrapper.flush(wrapper);
    }

    private static void flush(UnserializableComponentWrapper<?, ?> wrapper) {
        NodeOwner nodeOwner = wrapper.getElement().getNode().getOwner();
        if (nodeOwner instanceof StateTree) {
            StateTree owner = (StateTree)nodeOwner;
            owner.collectChanges(change -> {});
        }
    }

    static void doWithWrapper(UI ui, Consumer<UnserializableComponentWrapper> action) {
        ui.getElement().getNode().visitNodeTree(node -> ElementUtil.from((StateNode)node).flatMap(Element::getComponent).filter(UnserializableComponentWrapper.class::isInstance).map(UnserializableComponentWrapper.class::cast).ifPresent(action));
    }
}

