/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.kubernetes.starter.sessiontracker;

import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.server.VaadinSession;
import java.lang.reflect.Field;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionUtil {
    public static Runnable injectLockIfNeeded(VaadinSession session) {
        if (session != null) {
            Lock lock = session.getLockInstance();
            if (lock != null) {
                lock.lock();
                return () -> session.getLockInstance().unlock();
            }
            try {
                Field field = VaadinSession.class.getDeclaredField("lock");
                lock = new ReentrantLock();
                lock.lock();
                ReflectTools.setJavaFieldValue((Object)session, (Field)field, (Object)lock);
                return () -> SessionUtil.removeLock(session, field);
            }
            catch (NoSuchFieldException e) {
                SessionUtil.getLogger().debug("Cannot access lock field on VaadinSession", (Throwable)e);
            }
        }
        return () -> {};
    }

    private static void removeLock(VaadinSession session, Field field) {
        session.getLockInstance().unlock();
        ReflectTools.setJavaFieldValue((Object)session, (Field)field, null);
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(SessionUtil.class);
    }
}

