/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.kubernetes.starter.sessiontracker;

import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.kubernetes.starter.KubernetesKitProperties;
import com.vaadin.kubernetes.starter.sessiontracker.CurrentKey;
import com.vaadin.kubernetes.starter.sessiontracker.SameSite;
import com.vaadin.kubernetes.starter.sessiontracker.SessionSerializer;
import com.vaadin.kubernetes.starter.sessiontracker.SessionTrackerCookie;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionTrackerFilter
extends HttpFilter {
    private final transient SessionSerializer sessionSerializer;
    private final transient KubernetesKitProperties properties;

    public SessionTrackerFilter(SessionSerializer sessionSerializer, KubernetesKitProperties properties) {
        this.sessionSerializer = sessionSerializer;
        this.properties = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String cookieName = this.properties.getClusterKeyCookieName();
        SessionTrackerCookie.getValue(request, cookieName).ifPresent(key -> {
            CurrentKey.set(key);
            if (request.getSession(false) == null) {
                this.getLogger().info("Creating session for cluster key {}", key);
                request.getSession(true);
            }
        });
        try {
            HttpSession session = request.getSession(false);
            SessionTrackerCookie.setIfNeeded(session, request, response, cookieName, this.cookieConsumer(request));
            super.doFilter(request, response, chain);
            if (session != null && request.isRequestedSessionIdValid() && HandlerHelper.RequestType.UIDL.getIdentifier().equals(request.getParameter("v-r"))) {
                this.sessionSerializer.serialize(session);
            }
        }
        finally {
            CurrentKey.clear();
        }
    }

    private Consumer<Cookie> cookieConsumer(HttpServletRequest request) {
        return cookie -> {
            cookie.setHttpOnly(true);
            String path = request.getContextPath().isEmpty() ? "/" : request.getContextPath();
            cookie.setPath(path);
            SameSite sameSite = this.properties.getClusterKeyCookieSameSite();
            if (sameSite != null && !sameSite.attributeValue().isEmpty()) {
                cookie.setAttribute("SameSite", sameSite.attributeValue());
            }
        };
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    }
}

