/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.parser.plugins.backbone;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonIncludeProperties;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.vaadin.hilla.parser.core.AbstractPlugin;
import com.vaadin.hilla.parser.core.Node;
import com.vaadin.hilla.parser.core.NodeDependencies;
import com.vaadin.hilla.parser.core.NodePath;
import com.vaadin.hilla.parser.core.PluginConfiguration;
import com.vaadin.hilla.parser.jackson.JacksonObjectMapperFactory;
import com.vaadin.hilla.parser.models.ClassInfoModel;
import com.vaadin.hilla.parser.models.jackson.JacksonPropertyModel;
import com.vaadin.hilla.parser.plugins.backbone.BackbonePluginConfiguration;
import com.vaadin.hilla.parser.plugins.backbone.BackbonePluginException;
import com.vaadin.hilla.parser.plugins.backbone.nodes.EntityNode;
import com.vaadin.hilla.parser.plugins.backbone.nodes.PropertyNode;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.jspecify.annotations.NonNull;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.BeanDescription;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.MapperFeature;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.SerializationConfig;
import tools.jackson.databind.cfg.MapperConfig;
import tools.jackson.databind.introspect.AnnotatedClass;
import tools.jackson.databind.introspect.BeanPropertyDefinition;
import tools.jackson.databind.introspect.ClassIntrospector;
import tools.jackson.databind.json.JsonMapper;
import tools.jackson.databind.util.IgnorePropertiesUtil;

public final class PropertyPlugin
extends AbstractPlugin<BackbonePluginConfiguration> {
    private static final JsonMapper MAPPER = ((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().changeDefaultVisibility(vc -> vc.withVisibility(PropertyAccessor.SETTER, JsonAutoDetect.Visibility.PUBLIC_ONLY).withVisibility(PropertyAccessor.GETTER, JsonAutoDetect.Visibility.PUBLIC_ONLY))).disable(new MapperFeature[]{MapperFeature.SORT_PROPERTIES_ALPHABETICALLY})).build();
    private SerializationConfig serializationConfig = MAPPER.serializationConfig();

    public void enter(NodePath<?> nodePath) {
        if (nodePath.getNode() instanceof PropertyNode) {
            PropertyNode propertyNode = (PropertyNode)nodePath.getNode();
            propertyNode.setTarget(((JacksonPropertyModel)propertyNode.getSource()).getName());
        }
    }

    public void exit(NodePath<?> nodePath) {
    }

    public @NonNull NodeDependencies scan(@NonNull NodeDependencies nodeDependencies) {
        if (!(nodeDependencies.getNode() instanceof EntityNode)) {
            return nodeDependencies;
        }
        Node node = nodeDependencies.getNode();
        ClassInfoModel model = (ClassInfoModel)node.getSource();
        if (model.isEnum()) {
            return nodeDependencies;
        }
        Stream<Node> properties = this.collectProperties(model).map(PropertyNode::of);
        return nodeDependencies.appendChildNodes(properties);
    }

    public void setConfiguration(PluginConfiguration configuration) {
        super.setConfiguration(configuration);
        JacksonObjectMapperFactory factory = this.loadJacksonObjectMapperFactory();
        if (factory != null) {
            ObjectMapper mapper = factory.build();
            ObjectMapper jsonMapper = mapper.rebuild().disable(new MapperFeature[]{MapperFeature.SORT_PROPERTIES_ALPHABETICALLY}).build();
            this.serializationConfig = jsonMapper.serializationConfig();
        }
    }

    private Stream<JacksonPropertyModel> collectProperties(@NonNull ClassInfoModel model) {
        Object cls = Objects.requireNonNull(model).get();
        if (!(cls instanceof Class)) {
            throw new BackbonePluginException("Jackson: Only reflection models are supported");
        }
        JavaType javaType = this.serializationConfig.constructType((Class)cls);
        ClassIntrospector introspector = this.serializationConfig.classIntrospectorInstance();
        AnnotatedClass annotatedClass = introspector.introspectClassAnnotations(javaType);
        BeanDescription description = introspector.introspectForSerialization(javaType, annotatedClass);
        PropertyProcessor processor = new PropertyProcessor(description);
        return processor.stream();
    }

    private JacksonObjectMapperFactory loadJacksonObjectMapperFactory() {
        BackbonePluginConfiguration config = (BackbonePluginConfiguration)this.getConfiguration();
        if (config != null && config.getObjectMapperFactoryClassName() != null) {
            Class<?> cls;
            try {
                cls = Class.forName(config.getObjectMapperFactoryClassName());
            }
            catch (ClassNotFoundException e) {
                throw new BackbonePluginException("ObjectMapper factory class is not found", e);
            }
            if (!JacksonObjectMapperFactory.class.isAssignableFrom(cls)) {
                throw new BackbonePluginException(String.format("Class %s does not implement JacksonObjectMapperFactory interface", cls.getName()));
            }
            try {
                return (JacksonObjectMapperFactory)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new BackbonePluginException("Cannot instantiate ObjectMapper factory", e);
            }
        }
        return null;
    }

    private class PropertyProcessor {
        private final BeanDescription description;

        PropertyProcessor(BeanDescription description) {
            this.description = description;
        }

        public Stream<JacksonPropertyModel> stream() {
            Stream<JacksonPropertyModel> properties = this.description.findProperties().stream().map(prop -> JacksonPropertyModel.of((BeanPropertyDefinition)prop));
            properties = this.filterPrivateProperties(properties);
            properties = this.filterSuperClassProperties(properties);
            properties = this.filterPropertiesWithIgnoredTypes(properties);
            if (PropertyPlugin.this.serializationConfig.isEnabled(MapperFeature.REQUIRE_SETTERS_FOR_GETTERS)) {
                properties = this.filterSetterlessGetters(properties);
            }
            return this.filterIgnoredProperties(properties);
        }

        private Stream<JacksonPropertyModel> filterIgnoredProperties(Stream<JacksonPropertyModel> properties) {
            Set<String> ignored = this.findIgnored();
            Set<String> included = this.findIncluded();
            if (included != null || ignored != null && !ignored.isEmpty()) {
                properties = properties.filter(property -> !IgnorePropertiesUtil.shouldIgnore((Object)property.getName(), (Collection)ignored, (Collection)included));
            }
            return properties;
        }

        private Stream<JacksonPropertyModel> filterPropertiesWithIgnoredTypes(Stream<JacksonPropertyModel> properties) {
            HashMap ignores = new HashMap();
            AnnotationIntrospector introspector = PropertyPlugin.this.serializationConfig.getAnnotationIntrospector();
            return properties.filter(property -> {
                Class type = property.get().getPrimaryType().getRawClass();
                Boolean result = (Boolean)ignores.get(type);
                if (result == null) {
                    result = PropertyPlugin.this.serializationConfig.getConfigOverride(type).getIsIgnoredType();
                    if (result == null) {
                        AnnotatedClass annotatedClass;
                        JavaType javaType = PropertyPlugin.this.serializationConfig.constructType(type);
                        ClassIntrospector classIntrospector = PropertyPlugin.this.serializationConfig.classIntrospectorInstance();
                        BeanDescription classDesc = classIntrospector.introspectForSerialization(javaType, annotatedClass = classIntrospector.introspectClassAnnotations(javaType));
                        AnnotatedClass classInfo = classDesc.getClassInfo();
                        result = introspector.isIgnorableType((MapperConfig)PropertyPlugin.this.serializationConfig, classInfo);
                        if (result == null) {
                            result = Boolean.FALSE;
                        }
                    }
                    ignores.put(type, result);
                }
                return result == false;
            });
        }

        private Stream<JacksonPropertyModel> filterSetterlessGetters(Stream<JacksonPropertyModel> properties) {
            return properties.filter(property -> property.couldDeserialize() || property.isExplicitlyIncluded());
        }

        private Stream<JacksonPropertyModel> filterPrivateProperties(Stream<JacksonPropertyModel> properties) {
            return properties.filter(property -> !property.getAssociatedTypes().isEmpty());
        }

        private Stream<JacksonPropertyModel> filterSuperClassProperties(Stream<JacksonPropertyModel> properties) {
            return properties.filter(property -> property.getOwner().is(this.description.getBeanClass()));
        }

        private Set<String> findIgnored() {
            JsonIgnoreProperties.Value ignored = PropertyPlugin.this.serializationConfig.getDefaultPropertyIgnorals(this.description.getBeanClass(), this.description.getClassInfo());
            return ignored == null ? null : ignored.findIgnoredForSerialization();
        }

        private Set<String> findIncluded() {
            JsonIncludeProperties.Value included = PropertyPlugin.this.serializationConfig.getDefaultPropertyInclusions(this.description.getBeanClass(), this.description.getClassInfo());
            return included == null ? null : included.getIncluded();
        }
    }
}

