/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.parser.plugins.backbone;

import com.fasterxml.jackson.annotation.JsonValue;
import com.vaadin.hilla.parser.core.AbstractPlugin;
import com.vaadin.hilla.parser.core.Node;
import com.vaadin.hilla.parser.core.NodeDependencies;
import com.vaadin.hilla.parser.core.NodePath;
import com.vaadin.hilla.parser.models.ClassRefSignatureModel;
import com.vaadin.hilla.parser.models.SignatureModel;
import com.vaadin.hilla.parser.plugins.backbone.BackbonePluginConfiguration;
import com.vaadin.hilla.parser.plugins.backbone.nodes.TypeSignatureNode;
import com.vaadin.hilla.parser.plugins.backbone.nodes.TypedNode;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.jspecify.annotations.NonNull;

public class JsonValuePlugin
extends AbstractPlugin<BackbonePluginConfiguration> {
    private final Map<Class<?>, Optional<Class<?>>> jsonValues = new HashMap();

    public void enter(NodePath<?> nodePath) {
    }

    public void exit(NodePath<?> nodePath) {
    }

    public @NonNull NodeDependencies scan(@NonNull NodeDependencies nodeDependencies) {
        return nodeDependencies;
    }

    public @NonNull Node<?, ?> resolve(@NonNull Node<?, ?> node, @NonNull NodePath<?> parentPath) {
        TypedNode typedNode;
        SignatureModel signatureModel;
        if (node instanceof TypedNode && (signatureModel = (typedNode = (TypedNode)node).getType()) instanceof ClassRefSignatureModel) {
            ClassRefSignatureModel classRefSignatureModel = (ClassRefSignatureModel)signatureModel;
            Class cls = (Class)classRefSignatureModel.getClassInfo().get();
            Optional<Node> valueNode = this.getValueType(cls).map(SignatureModel::of).map(TypeSignatureNode::of);
            return valueNode.orElse(node);
        }
        return node;
    }

    private Optional<Class<?>> getValueType(Class<?> cls) {
        return this.jsonValues.computeIfAbsent(cls, this::findValueType);
    }

    private Optional<Class<?>> findValueType(Class<?> cls) {
        return Arrays.stream(cls.getMethods()).filter(method -> method.isAnnotationPresent(JsonValue.class)).map(Method::getReturnType).findAny();
    }
}

