/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.parser.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.vaadin.hilla.parser.core.OpenAPIFileType;
import com.vaadin.hilla.parser.core.ParserException;
import com.vaadin.hilla.parser.core.Plugin;
import com.vaadin.hilla.parser.core.PluginExecutor;
import com.vaadin.hilla.parser.core.PluginManager;
import com.vaadin.hilla.parser.core.RootNode;
import com.vaadin.hilla.parser.core.SharedStorage;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jspecify.annotations.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Parser {
    private static final Logger logger = LoggerFactory.getLogger(Parser.class);
    private final Config config;
    private static final String ENDPOINT_EXPOSED_AND_ACL_ANNOTATIONS_ERROR_TEMPLATE = "Class `%s` is annotated with `%s` and `%s` annotation. %n\nClasses annotated with `%s` must not contain any of access control annotations and %n\nthis exception is for preventing the application startup with misconfiguration. The class level access %n\ncontrol rules of the child class will be applied for the inherited methods of this class. If the access %n\ncontrol rules for an inherited method should not follow the rules of the child endpoint, that method %n\nshould be overridden and annotated with the desired access control annotations explicitly. %n\n".stripIndent();
    private static final Set<String> ACL_ANNOTATIONS = Set.of("jakarta.annotation.security.DenyAll", "jakarta.annotation.security.PermitAll", "jakarta.annotation.security.RolesAllowed", "com.vaadin.flow.server.auth.AnonymousAllowed");
    private static final List<String> INTERNAL_BROWSER_CALLABLES = List.of("com.vaadin.hilla.signals.handler.SignalsHandler");

    public Parser() {
        try {
            String basicOpenAPIString = new String(Objects.requireNonNull(Parser.class.getResourceAsStream("OpenAPIBase.json")).readAllBytes());
            OpenAPI openAPI = Parser.parseOpenAPIFile(basicOpenAPIString, OpenAPIFileType.JSON, null);
            this.config = new Config(openAPI);
        }
        catch (IOException e) {
            throw new ParserException("Failed to parse openAPI specification", e);
        }
    }

    private static OpenAPI parseOpenAPIFile(@NonNull String source, @NonNull OpenAPIFileType type, OpenAPI origin) {
        try {
            ObjectMapper mapper = type.getMapper();
            if (origin != null) {
                return (OpenAPI)mapper.readerForUpdating((Object)origin).readValue(source);
            }
            return (OpenAPI)mapper.readValue(source, OpenAPI.class);
        }
        catch (Exception e) {
            throw new ParserException("Failed to parse OpenAPI file", e);
        }
    }

    public @NonNull Parser addPlugin(@NonNull Plugin plugin) {
        this.config.plugins.add(Objects.requireNonNull(plugin));
        return this;
    }

    public @NonNull Parser adjustOpenAPI(@NonNull Consumer<OpenAPI> action) {
        action.accept(this.config.openAPI);
        return this;
    }

    public @NonNull Parser classPath(String ... classPathElements) {
        return this.classPath(classPathElements, true);
    }

    public @NonNull Parser classPath(@NonNull String[] classPathElements, boolean override) {
        return this.classPath(Arrays.asList(Objects.requireNonNull(classPathElements)), override);
    }

    public @NonNull Parser classPath(@NonNull Collection<String> classPathElements) {
        return this.classPath(classPathElements, true);
    }

    public @NonNull Parser classPath(@NonNull Collection<String> classPathElements, boolean override) {
        if (override || this.config.classPathElements == null) {
            this.config.classPathElements = new HashSet<String>(Objects.requireNonNull(classPathElements));
        }
        return this;
    }

    public @NonNull Parser endpointAnnotations(@NonNull List<Class<? extends Annotation>> annotations) {
        return this.endpointAnnotations(annotations, true);
    }

    public @NonNull Parser endpointAnnotations(@NonNull List<Class<? extends Annotation>> annotations, boolean override) {
        if (override || this.config.endpointAnnotations == null) {
            this.config.endpointAnnotations = Objects.requireNonNull(annotations);
        }
        return this;
    }

    public @NonNull Parser endpointExposedAnnotations(@NonNull List<Class<? extends Annotation>> annotations) {
        return this.endpointExposedAnnotations(annotations, true);
    }

    public @NonNull Parser endpointExposedAnnotations(@NonNull List<Class<? extends Annotation>> annotations, boolean override) {
        if (override || this.config.endpointExposedAnnotations == null) {
            this.config.endpointExposedAnnotations = Objects.requireNonNull(annotations);
        }
        return this;
    }

    public @NonNull OpenAPI execute(List<Class<?>> browserCallables) {
        Objects.requireNonNull(this.config.classPathElements, "[JVM Parser] classPath is not provided.");
        if (this.config.endpointAnnotations == null || this.config.endpointAnnotations.isEmpty()) {
            throw new IllegalArgumentException("[JVM Parser] endpoint annotations are not provided.");
        }
        logger.debug("JVM Parser started");
        browserCallables = browserCallables.stream().filter(cls -> !INTERNAL_BROWSER_CALLABLES.contains(cls.getName())).toList();
        SharedStorage storage = new SharedStorage(this.config);
        this.validateEndpointExposedClassesForAclAnnotations(browserCallables);
        RootNode rootNode = new RootNode(browserCallables, storage.getOpenAPI());
        PluginManager pluginManager = new PluginManager(storage.getParserConfig().getPlugins());
        pluginManager.setStorage(storage);
        PluginExecutor pluginExecutor = new PluginExecutor(pluginManager, rootNode);
        pluginExecutor.execute();
        logger.debug("JVM Parser finished successfully");
        return storage.getOpenAPI();
    }

    private void validateEndpointExposedClassesForAclAnnotations(List<Class<?>> browserCallables) {
        browserCallables.stream().flatMap(Parser::getSuperclasses).flatMap(browserCallable -> this.config.getEndpointExposedAnnotations().stream().map(ann -> List.of(browserCallable, ann))).filter(pair -> ((Class)pair.get(0)).isAnnotationPresent((Class)pair.get(1))).forEach(pair -> {
            this.checkClassLevelAnnotation((Class)pair.get(0), (Class)pair.get(1));
            this.checkMethodLevelAnnotation((Class)pair.get(0), (Class)pair.get(1));
        });
    }

    private static Stream<Class<?>> getSuperclasses(Class<?> clazz) {
        return Stream.iterate(clazz.getSuperclass(), Objects::nonNull, Class::getSuperclass);
    }

    private void checkClassLevelAnnotation(Class<?> browserCallable, Class<?> exposedAnnotation) {
        Arrays.stream(browserCallable.getAnnotations()).forEach(annotationInfo -> this.throwIfAnnotationIsAclAnnotation(annotationInfo.annotationType().getName(), browserCallable, exposedAnnotation));
    }

    private void checkMethodLevelAnnotation(Class<?> browserCallable, Class<?> exposedAnnotation) {
        for (Method method : browserCallable.getMethods()) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = method.getDeclaredAnnotations()) {
                this.throwIfAnnotationIsAclAnnotation(annotation.annotationType().getName(), browserCallable, exposedAnnotation);
            }
        }
    }

    private void throwIfAnnotationIsAclAnnotation(String annotationName, Class<?> browserCallable, Class<?> exposedAnnotation) {
        if (ACL_ANNOTATIONS.contains(annotationName)) {
            throw new ParserException(String.format(ENDPOINT_EXPOSED_AND_ACL_ANNOTATIONS_ERROR_TEMPLATE, browserCallable.getName(), exposedAnnotation.getName(), annotationName, exposedAnnotation.getName()));
        }
    }

    public @NonNull Config getConfig() {
        return this.config;
    }

    public @NonNull Parser openAPISource(@NonNull String source, @NonNull OpenAPIFileType type) {
        this.config.openAPI = Parser.parseOpenAPIFile(Objects.requireNonNull(source), Objects.requireNonNull(type), this.config.openAPI);
        return this;
    }

    public @NonNull Parser plugins(Plugin ... plugins) {
        return this.plugins(Arrays.asList(plugins));
    }

    public @NonNull Parser plugins(@NonNull Collection<? extends Plugin> plugins) {
        this.config.plugins.clear();
        this.config.plugins.addAll(Objects.requireNonNull(plugins));
        return this;
    }

    public static final class Config {
        private final List<Plugin> plugins = new ArrayList<Plugin>();
        private Set<String> classPathElements;
        private List<Class<? extends Annotation>> endpointAnnotations = List.of();
        private List<Class<? extends Annotation>> endpointExposedAnnotations = List.of();
        private OpenAPI openAPI;

        private Config(OpenAPI openAPI) {
            this.openAPI = openAPI;
        }

        public @NonNull Set<String> getClassPathElements() {
            return this.classPathElements;
        }

        public @NonNull List<Class<? extends Annotation>> getEndpointAnnotations() {
            return this.endpointAnnotations;
        }

        public @NonNull List<Class<? extends Annotation>> getEndpointExposedAnnotations() {
            return this.endpointExposedAnnotations;
        }

        public @NonNull OpenAPI getOpenAPI() {
            return this.openAPI;
        }

        public @NonNull Collection<Plugin> getPlugins() {
            return this.plugins;
        }
    }
}

