/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.parser.models;

import com.vaadin.hilla.parser.models.AnnotatedAbstractModel;
import com.vaadin.hilla.parser.models.ClassInfoModel;
import com.vaadin.hilla.parser.models.ClassMemberModel;
import com.vaadin.hilla.parser.models.MethodInfoReflectionModel;
import com.vaadin.hilla.parser.models.MethodInfoSourceModel;
import com.vaadin.hilla.parser.models.MethodParameterInfoModel;
import com.vaadin.hilla.parser.models.NamedModel;
import com.vaadin.hilla.parser.models.ParameterizedModel;
import com.vaadin.hilla.parser.models.SignatureModel;
import com.vaadin.hilla.parser.models.TypeParameterModel;
import io.github.classgraph.MethodInfo;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.NonNull;

public abstract class MethodInfoModel
extends AnnotatedAbstractModel
implements ClassMemberModel,
ParameterizedModel {
    static final Comparator<MethodInfoModel> METHOD_ORDER = Comparator.comparing(NamedModel::getName);
    private ClassInfoModel owner;
    private List<MethodParameterInfoModel> parameters;
    private SignatureModel resultType;
    private List<TypeParameterModel> typeParameters;

    @Deprecated
    public static MethodInfoModel of(@NonNull MethodInfo origin) {
        return new MethodInfoSourceModel(Objects.requireNonNull(origin));
    }

    public static MethodInfoModel of(@NonNull Executable origin) {
        return Objects.requireNonNull(origin) instanceof Constructor ? new MethodInfoReflectionModel.Constructor((Constructor)origin) : new MethodInfoReflectionModel.Regular((Method)origin);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MethodInfoModel)) {
            return false;
        }
        MethodInfoModel other = (MethodInfoModel)obj;
        return this.equalsIgnoreParameters(other) && this.getParameters().equals(other.getParameters());
    }

    public boolean equalsIgnoreParameters(MethodInfoModel other) {
        return this.getName().equals(other.getName()) && this.getModifiers() == other.getModifiers() && this.getResultType().equals(other.getResultType()) && this.getClassName().equals(other.getClassName()) && this.getTypeParameters().equals(other.getTypeParameters());
    }

    public boolean equalsIgnoreParameters(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MethodInfoModel)) {
            return false;
        }
        return this.equalsIgnoreParameters((MethodInfoModel)obj);
    }

    public abstract String getClassName();

    public Class<MethodInfoModel> getCommonModelClass() {
        return MethodInfoModel.class;
    }

    public abstract int getModifiers();

    @Override
    public ClassInfoModel getOwner() {
        if (this.owner == null) {
            this.owner = this.prepareOwner();
        }
        return this.owner;
    }

    public List<MethodParameterInfoModel> getParameters() {
        if (this.parameters == null) {
            this.parameters = this.prepareParameters();
        }
        return this.parameters;
    }

    public SignatureModel getResultType() {
        if (this.resultType == null) {
            this.resultType = this.prepareResultType();
        }
        return this.resultType;
    }

    @Override
    public List<TypeParameterModel> getTypeParameters() {
        if (this.typeParameters == null) {
            this.typeParameters = this.prepareTypeParameters();
        }
        return this.typeParameters;
    }

    public int hashCode() {
        return this.hashCodeIgnoreParameters() + 53 * this.getParameters().hashCode();
    }

    public int hashCodeIgnoreParameters() {
        return this.getName().hashCode() + 11 * this.getResultType().hashCode() + 17 * this.getModifiers() + 23 * this.getClassName().hashCode();
    }

    public abstract boolean isAbstract();

    public abstract boolean isBridge();

    public abstract boolean isConstructor();

    public abstract boolean isFinal();

    public abstract boolean isNative();

    public abstract boolean isPrivate();

    public abstract boolean isProtected();

    public abstract boolean isPublic();

    public abstract boolean isStatic();

    public abstract boolean isStrict();

    public abstract boolean isSynchronized();

    public abstract boolean isSynthetic();

    public abstract boolean isVarArgs();

    public String toString() {
        return "MethodInfoModel[" + String.valueOf(this.get()) + "]";
    }

    protected abstract ClassInfoModel prepareOwner();

    protected abstract List<MethodParameterInfoModel> prepareParameters();

    protected abstract SignatureModel prepareResultType();

    protected abstract List<TypeParameterModel> prepareTypeParameters();
}

