/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.parser.models;

import com.vaadin.hilla.parser.models.AnnotationInfoModel;
import com.vaadin.hilla.parser.models.BaseSignatureModel;
import com.vaadin.hilla.parser.models.ReflectionSignatureModel;
import java.lang.reflect.AnnotatedType;
import java.util.List;

final class BaseSignatureReflectionModel
extends BaseSignatureModel
implements ReflectionSignatureModel {
    private final Class<?> inner;
    private final AnnotatedType origin;

    BaseSignatureReflectionModel(AnnotatedType origin) {
        this.origin = origin;
        this.inner = (Class)origin.getType();
    }

    @Override
    public AnnotatedType get() {
        return this.origin;
    }

    @Override
    public Class<?> getType() {
        return this.inner;
    }

    @Override
    public boolean isBoolean() {
        return this.inner == Boolean.TYPE;
    }

    @Override
    public boolean isByte() {
        return this.inner == Byte.TYPE;
    }

    @Override
    public boolean isCharacter() {
        return this.inner == Character.TYPE;
    }

    @Override
    public boolean isDouble() {
        return this.inner == Double.TYPE;
    }

    @Override
    public boolean isFloat() {
        return this.inner == Float.TYPE;
    }

    @Override
    public boolean isInteger() {
        return this.inner == Integer.TYPE;
    }

    @Override
    public boolean isJDKClass() {
        return true;
    }

    @Override
    public boolean isLong() {
        return this.inner == Long.TYPE;
    }

    @Override
    public boolean isPrimitive() {
        return this.inner != Void.TYPE;
    }

    @Override
    public boolean isShort() {
        return this.inner == Short.TYPE;
    }

    @Override
    public boolean isVoid() {
        return this.inner == Void.TYPE;
    }

    @Override
    protected List<AnnotationInfoModel> prepareAnnotations() {
        return BaseSignatureReflectionModel.processAnnotations(this.origin.getAnnotations());
    }

    static class Bare
    extends BaseSignatureModel
    implements ReflectionSignatureModel {
        private final Class<?> origin;

        public Bare(Class<?> origin) {
            this.origin = origin;
        }

        @Override
        public Class<?> get() {
            return this.origin;
        }

        @Override
        public Class<?> getType() {
            return this.origin;
        }

        @Override
        public boolean isBoolean() {
            return this.origin == Boolean.TYPE;
        }

        @Override
        public boolean isByte() {
            return this.origin == Byte.TYPE;
        }

        @Override
        public boolean isCharacter() {
            return this.origin == Character.TYPE;
        }

        @Override
        public boolean isDouble() {
            return this.origin == Double.TYPE;
        }

        @Override
        public boolean isFloat() {
            return this.origin == Float.TYPE;
        }

        @Override
        public boolean isInteger() {
            return this.origin == Integer.TYPE;
        }

        @Override
        public boolean isJDKClass() {
            return true;
        }

        @Override
        public boolean isLong() {
            return this.origin == Long.TYPE;
        }

        @Override
        public boolean isPrimitive() {
            return this.origin != Void.TYPE;
        }

        @Override
        public boolean isShort() {
            return this.origin == Short.TYPE;
        }

        @Override
        public boolean isVoid() {
            return this.origin == Void.TYPE;
        }

        @Override
        protected List<AnnotationInfoModel> prepareAnnotations() {
            return Bare.processAnnotations(this.origin.getAnnotations());
        }
    }
}

