/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.engine;

import com.vaadin.hilla.engine.EngineConfiguration;
import com.vaadin.hilla.engine.ParserConfiguration;
import com.vaadin.hilla.engine.ParserException;
import com.vaadin.hilla.parser.core.OpenAPIFileType;
import com.vaadin.hilla.parser.core.Parser;
import com.vaadin.hilla.parser.core.PluginConfiguration;
import com.vaadin.hilla.parser.core.PluginManager;
import com.vaadin.hilla.parser.utils.JsonPrinter;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jspecify.annotations.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ParserProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ParserProcessor.class);
    private final Path baseDir;
    private final Set<Path> classPath;
    private final Path openAPIFile;
    private final ParserConfiguration.PluginsProcessor pluginsProcessor = new ParserConfiguration.PluginsProcessor();
    private List<Class<? extends Annotation>> endpointAnnotations = List.of();
    private List<Class<? extends Annotation>> endpointExposedAnnotations = List.of();
    private String openAPIBasePath;

    public ParserProcessor(EngineConfiguration conf) {
        this.baseDir = conf.getBaseDir();
        this.openAPIFile = conf.getOpenAPIFile();
        this.classPath = conf.getClasspath();
        this.endpointAnnotations = conf.getEndpointAnnotations();
        this.endpointExposedAnnotations = conf.getEndpointExposedAnnotations();
        this.applyConfiguration(conf.getParser());
    }

    private String createOpenAPI(List<Class<?>> endpoints) throws IOException {
        Parser parser = new Parser().classPath((Collection)this.classPath.stream().map(Path::toString).collect(Collectors.toSet())).endpointAnnotations(this.endpointAnnotations).endpointExposedAnnotations(this.endpointExposedAnnotations);
        this.preparePlugins(parser);
        this.prepareOpenAPIBase(parser);
        logger.debug("Starting JVM Parser");
        OpenAPI openAPI = parser.execute(endpoints);
        return new JsonPrinter().pretty().writeAsString((Object)openAPI);
    }

    public void process(List<Class<?>> endpoints) throws ParserException {
        String openAPIString;
        try {
            Files.createDirectories(this.openAPIFile.getParent(), new FileAttribute[0]);
            openAPIString = this.createOpenAPI(endpoints);
        }
        catch (IOException e) {
            throw new ParserException("Unable to prepare OpenAPI definition", e);
        }
        Optional.of(this.openAPIFile).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(this::readFromFile).filter(openAPIString::equals).ifPresentOrElse(s -> logger.debug("OpenAPI definition has not changed"), () -> {
            try {
                Files.write(this.openAPIFile, openAPIString.getBytes(), new OpenOption[0]);
                logger.debug("OpenAPI definition file saved");
            }
            catch (IOException e) {
                throw new ParserException("Unable to save OpenAPI file", e);
            }
        });
    }

    private void applyConfiguration(ParserConfiguration parserConfiguration) {
        if (parserConfiguration == null) {
            return;
        }
        this.applyEndpointAnnotations(parserConfiguration.getEndpointAnnotations());
        this.applyEndpointExposedAnnotations(parserConfiguration.getEndpointExposedAnnotations());
        parserConfiguration.getOpenAPIBasePath().ifPresent(this::applyOpenAPIBase);
        parserConfiguration.getPlugins().ifPresent(this::applyPlugins);
    }

    private void applyEndpointAnnotations(@NonNull List<Class<? extends Annotation>> endpointAnnotations) {
        this.endpointAnnotations = Objects.requireNonNull(endpointAnnotations);
    }

    private void applyEndpointExposedAnnotations(@NonNull List<Class<? extends Annotation>> endpointExposedAnnotations) {
        this.endpointExposedAnnotations = Objects.requireNonNull(endpointExposedAnnotations);
    }

    private void applyOpenAPIBase(@NonNull String openAPIBasePath) {
        this.openAPIBasePath = openAPIBasePath;
    }

    private void applyPlugins(@NonNull ParserConfiguration.Plugins plugins) {
        this.pluginsProcessor.setConfig(plugins);
    }

    private void prepareOpenAPIBase(Parser parser) {
        if (this.openAPIBasePath == null) {
            return;
        }
        try {
            Path path = this.baseDir.resolve(this.openAPIBasePath);
            String fileName = path.getFileName().toString();
            if (!(fileName.endsWith("yml") || fileName.endsWith("yaml") || fileName.endsWith("json"))) {
                throw new IOException("No OpenAPI base file found");
            }
            parser.openAPISource(Files.readString(path), fileName.endsWith("json") ? OpenAPIFileType.JSON : OpenAPIFileType.YAML);
        }
        catch (IOException e) {
            throw new ParserException("Failed loading OpenAPI spec file", e);
        }
    }

    private void preparePlugins(Parser parser) {
        List loadedPlugins = this.pluginsProcessor.process().stream().map(plugin -> PluginManager.load((String)plugin.getName(), (PluginConfiguration)plugin.getConfiguration())).collect(Collectors.toList());
        parser.plugins(loadedPlugins);
    }

    private String readFromFile(Path path) {
        try {
            return Files.readString(path);
        }
        catch (IOException e) {
            logger.error("Unable to read file", (Throwable)e);
            return null;
        }
    }
}

