/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.engine;

import com.vaadin.hilla.parser.core.PluginConfiguration;
import com.vaadin.hilla.parser.plugins.backbone.BackbonePlugin;
import com.vaadin.hilla.parser.plugins.model.ModelPlugin;
import com.vaadin.hilla.parser.plugins.nonnull.NonnullPlugin;
import com.vaadin.hilla.parser.plugins.subtypes.SubTypesPlugin;
import com.vaadin.hilla.parser.plugins.transfertypes.MultipartFileCheckerPlugin;
import com.vaadin.hilla.parser.plugins.transfertypes.TransferTypesPlugin;
import com.vaadin.hilla.parser.utils.ConfigList;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jspecify.annotations.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ParserConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParserConfiguration.class);
    private List<Class<? extends Annotation>> endpointAnnotations = List.of();
    private List<Class<? extends Annotation>> endpointExposedAnnotations = List.of();
    private String openAPIBasePath;
    private Plugins plugins;

    public List<Class<? extends Annotation>> getEndpointAnnotations() {
        return this.endpointAnnotations;
    }

    public List<Class<? extends Annotation>> getEndpointExposedAnnotations() {
        return this.endpointExposedAnnotations;
    }

    public Optional<String> getOpenAPIBasePath() {
        return Optional.ofNullable(this.openAPIBasePath);
    }

    public Optional<Plugins> getPlugins() {
        return Optional.ofNullable(this.plugins);
    }

    public void setEndpointAnnotations(@NonNull List<Class<? extends Annotation>> endpointAnnotations) {
        this.endpointAnnotations = endpointAnnotations;
    }

    public void setEndpointExposedAnnotations(@NonNull List<Class<? extends Annotation>> endpointExposedAnnotations) {
        this.endpointExposedAnnotations = endpointExposedAnnotations;
    }

    void setOpenAPIBasePath(String openAPIBasePath) {
        this.openAPIBasePath = openAPIBasePath;
    }

    void setPlugins(Plugins plugins) {
        this.plugins = plugins;
    }

    public static class Plugins
    implements ConfigList<Plugin> {
        private final List<Plugin> disable = new ArrayList<Plugin>();
        private final boolean disableAllDefaults;
        private final List<Plugin> use = new ArrayList<Plugin>();

        public Plugins() {
            this.disableAllDefaults = false;
        }

        Plugins(@NonNull Collection<Plugin> use, @NonNull Collection<Plugin> disable, boolean disableAllDefaults) {
            this.disable.addAll(disable);
            this.use.addAll(use);
            this.disableAllDefaults = disableAllDefaults;
        }

        public Collection<Plugin> getDisabledOptions() {
            return this.disable;
        }

        public Collection<Plugin> getUsedOptions() {
            return this.use;
        }

        public boolean shouldAllDefaultsBeDisabled() {
            return this.disableAllDefaults;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Plugins plugins = (Plugins)o;
            return this.disableAllDefaults == plugins.disableAllDefaults && Objects.equals(this.disable, plugins.disable) && Objects.equals(this.use, plugins.use);
        }

        public int hashCode() {
            return Objects.hash(this.disable, this.disableAllDefaults, this.use);
        }
    }

    static class PluginsProcessor
    extends ConfigList.Processor<Plugin> {
        private static final List<Plugin> DEFAULTS = PluginsProcessor.createDefaults();

        private static List<Plugin> createDefaults() {
            ArrayList<Plugin> plugins = new ArrayList<Plugin>();
            plugins.add(new Plugin(BackbonePlugin.class.getName()));
            plugins.add(new Plugin(MultipartFileCheckerPlugin.class.getName()));
            plugins.add(new Plugin(TransferTypesPlugin.class.getName()));
            try {
                Class<?> kotlinNullabilityClass = Class.forName("com.vaadin.hilla.parser.plugins.nonnull.kotlin.KotlinNullabilityPlugin");
                Class.forName("kotlin.reflect.KClass");
                plugins.add(new Plugin(kotlinNullabilityClass.getName()));
            }
            catch (Throwable e) {
                LOGGER.debug("Kotlin nullability plugin is not going to be loaded. If you wish to enable it, please ensure that both 'kotlin-reflect' and 'hilla-parser-jvm-plugin-nonnull-kotlin' are in your classpath.");
            }
            plugins.add(new Plugin(NonnullPlugin.class.getName()));
            plugins.add(new Plugin(SubTypesPlugin.class.getName()));
            plugins.add(new Plugin(ModelPlugin.class.getName()));
            return List.copyOf(plugins);
        }

        PluginsProcessor() {
            super(DEFAULTS);
        }
    }

    public static class Plugin {
        private PluginConfiguration configuration;
        private String name;

        public Plugin() {
        }

        Plugin(String name) {
            this.name = name;
        }

        public Plugin(String name, PluginConfiguration configuration) {
            this(name);
            this.configuration = configuration;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Plugin)) {
                return false;
            }
            return Objects.equals(this.name, ((Plugin)other).name);
        }

        public PluginConfiguration getConfiguration() {
            return this.configuration;
        }

        public @NonNull String getName() {
            return this.name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

