/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.route;

import com.vaadin.flow.internal.hilla.FileRouterRequestUtil;
import com.vaadin.flow.internal.menu.MenuRegistry;
import com.vaadin.flow.server.AbstractConfiguration;
import com.vaadin.flow.server.Mode;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.menu.AvailableViewInfo;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.springframework.http.server.RequestPath;
import org.springframework.util.AntPathMatcher;

@NullMarked
public class RouteUtil
implements FileRouterRequestUtil {
    private @Nullable Map<String, AvailableViewInfo> registeredRoutes = null;

    public boolean isAnonymousRoute(HttpServletRequest request) {
        this.collectClientRoutesIfNecessary(request);
        return this.getRouteData(request, false).map(info -> !info.loginRequired()).orElse(false);
    }

    public boolean isSecuredRoute(HttpServletRequest request) {
        this.collectClientRoutesIfNecessary(request);
        return this.getRouteData(request, false).map(AvailableViewInfo::loginRequired).orElse(false);
    }

    public Set<String> getAllowedAuthorities(HttpServletRequest request) {
        this.collectClientRoutesIfNecessary(request);
        return this.getRouteData(request, false).map(AvailableViewInfo::rolesAllowed).map(Set::of).orElseGet(Collections::emptySet);
    }

    void setRoutes(Map<String, AvailableViewInfo> registeredRoutes) {
        this.registeredRoutes = registeredRoutes == null ? null : new HashMap<String, AvailableViewInfo>(registeredRoutes);
    }

    public boolean isRouteAllowed(HttpServletRequest request) {
        this.collectClientRoutesIfNecessary(request);
        return this.getRouteData(request, true).isPresent();
    }

    private void collectClientRoutesIfNecessary(HttpServletRequest request) {
        ApplicationConfiguration config = ApplicationConfiguration.get((VaadinContext)new VaadinServletContext(request.getServletContext()));
        boolean isLiveReloadMode = config.getMode().equals((Object)Mode.DEVELOPMENT_FRONTEND_LIVERELOAD);
        if (this.registeredRoutes == null || isLiveReloadMode) {
            this.collectClientRoutes(config);
        }
    }

    private static void filterClientViews(Map<String, AvailableViewInfo> configurations, HttpServletRequest request) {
        boolean isUserAuthenticated = request.getUserPrincipal() != null;
        HashSet<String> clientEntries = new HashSet<String>(configurations.keySet());
        for (String key : clientEntries) {
            if (!configurations.containsKey(key)) continue;
            AvailableViewInfo viewInfo = configurations.get(key);
            boolean routeValid = RouteUtil.validateViewAccessible(viewInfo, isUserAuthenticated, arg_0 -> ((HttpServletRequest)request).isUserInRole(arg_0));
            if (routeValid) continue;
            configurations.remove(key);
            if (viewInfo.children() == null || viewInfo.children().isEmpty()) continue;
            RouteUtil.removeChildren(configurations, viewInfo, key);
        }
    }

    private static boolean validateViewAccessible(AvailableViewInfo viewInfo, boolean isUserAuthenticated, Predicate<? super String> roleAuthentication) {
        if (viewInfo.loginRequired() && !isUserAuthenticated) {
            return false;
        }
        String[] roles = viewInfo.rolesAllowed();
        return roles == null || roles.length == 0 || Arrays.stream(roles).anyMatch(roleAuthentication);
    }

    public static void removeChildren(Map<String, AvailableViewInfo> configurations, AvailableViewInfo viewInfo, String parentPath) {
        for (AvailableViewInfo child : viewInfo.children()) {
            String childRoute = (parentPath + "/" + child.route()).replace("//", "/");
            configurations.remove(childRoute);
            if (child.children() == null) continue;
            RouteUtil.removeChildren(configurations, child, childRoute);
        }
    }

    private Optional<AvailableViewInfo> getRouteData(HttpServletRequest request, boolean filterByPrincipal) {
        HashMap<String, AvailableViewInfo> availableRoutes;
        RequestPath requestPath = RequestPath.parse((String)request.getRequestURI(), (String)request.getContextPath());
        HashMap<String, AvailableViewInfo> hashMap = availableRoutes = this.registeredRoutes != null ? new HashMap<String, AvailableViewInfo>(this.registeredRoutes) : Collections.emptyMap();
        if (filterByPrincipal) {
            RouteUtil.filterClientViews(availableRoutes, request);
        }
        return Optional.ofNullable(this.getRouteByPath(availableRoutes, requestPath.pathWithinApplication().value()));
    }

    private void collectClientRoutes(ApplicationConfiguration config) {
        this.setRoutes(MenuRegistry.collectClientMenuItems((boolean)false, (AbstractConfiguration)config, null));
    }

    protected synchronized @Nullable AvailableViewInfo getRouteByPath(Map<String, AvailableViewInfo> availableRoutes, String path) {
        Set<String> routes = availableRoutes.keySet();
        AntPathMatcher pathMatcher = new AntPathMatcher();
        return Stream.of(this.addTrailingSlash(path), this.removeTrailingSlash(path)).map(p -> {
            for (String route : routes) {
                if (!pathMatcher.match(route, p)) continue;
                return (AvailableViewInfo)availableRoutes.get(route);
            }
            return null;
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private String addTrailingSlash(String path) {
        return path.endsWith("/") ? path : path + "/";
    }

    private String removeTrailingSlash(String path) {
        return path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
    }
}

