/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla;

import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.FrontendUtils;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.server.Platform;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.hilla.EndpointController;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HillaStats {
    private static final Logger LOGGER = LoggerFactory.getLogger(EndpointController.class);
    static final String HAS_REACT = "has-react";
    static final String HAS_LIT = "has-lit";
    static final String HAS_REACT_LIT = "has-react-lit";
    static final String HAS_HILLA_FS_ROUTE = "has-hilla-fs-route";
    static final String HAS_HILLA_CUSTOM_ROUTE = "has-hilla-custom-route";
    static final String HAS_HYBRID_ROUTING = "has-hybrid-routing";
    static final String HAS_ENDPOINT = "has-endpoint";
    static final String ENDPOINT_ACTIVE = "endpoint-active";
    static final String HILLA_USAGE = "hilla";

    private static void reportHasReactAndLit(DeploymentConfiguration deploymentConfiguration, String hillaVersion) {
        try {
            File frontendFolder = deploymentConfiguration.getFrontendFolder();
            boolean isHillaUsed = FrontendUtils.isHillaUsed((File)frontendFolder);
            boolean isReactRouterRequired = FrontendUtils.isReactRouterRequired((File)frontendFolder);
            if (isHillaUsed && isReactRouterRequired && deploymentConfiguration.isReactEnabled()) {
                UsageStatistics.markAsUsed((String)HAS_REACT, (String)hillaVersion);
            }
            if (isHillaUsed && !isReactRouterRequired && !deploymentConfiguration.isReactEnabled()) {
                UsageStatistics.markAsUsed((String)HAS_LIT, (String)hillaVersion);
            }
            if (isHillaUsed && isReactRouterRequired && !deploymentConfiguration.isReactEnabled()) {
                UsageStatistics.markAsUsed((String)HAS_REACT_LIT, (String)hillaVersion);
            }
        }
        catch (Throwable e) {
            LOGGER.debug("Failed to report HasReactAndLit", e);
        }
    }

    private static void reportHasRouter(VaadinService service, boolean hasHillaFsRoute, String hillaVersion) {
        try {
            boolean hasHybridRouting;
            boolean hasHillaCustomRoute;
            if (hasHillaFsRoute) {
                UsageStatistics.markAsUsed((String)HAS_HILLA_FS_ROUTE, (String)hillaVersion);
            }
            DeploymentConfiguration deploymentConfiguration = service.getDeploymentConfiguration();
            Path frontendFolderPath = deploymentConfiguration.getFrontendFolder().toPath();
            Path routesTsx = frontendFolderPath.resolve("routes.tsx");
            Path routesTs = frontendFolderPath.resolve("routes.ts");
            boolean bl = hasHillaCustomRoute = Files.exists(routesTsx, new LinkOption[0]) || Files.exists(routesTs, new LinkOption[0]);
            if (hasHillaCustomRoute) {
                UsageStatistics.markAsUsed((String)HAS_HILLA_CUSTOM_ROUTE, (String)hillaVersion);
            }
            if (hasHillaFsRoute || hasHillaCustomRoute) {
                UsageStatistics.markAsUsed((String)HILLA_USAGE, (String)hillaVersion);
            }
            boolean hasFlowRoute = !service.getRouter().getRegistry().getRegisteredRoutes().isEmpty();
            boolean bl2 = hasHybridRouting = hasFlowRoute && (hasHillaFsRoute || hasHillaCustomRoute);
            if (hasHybridRouting) {
                UsageStatistics.markAsUsed((String)HAS_HYBRID_ROUTING, (String)hillaVersion);
            }
        }
        catch (Throwable e) {
            LOGGER.debug("Failed to report HasRouter", e);
        }
    }

    private static String getHillaVersion() {
        String hillaVersion = Platform.getHillaVersion().orElse("?");
        LOGGER.debug("Hilla version determined by Platform.getHillaVersion(): {}", (Object)hillaVersion);
        return hillaVersion;
    }

    public static void reportGenericHasFeatures(VaadinService service, boolean hasHillaFsRoute) {
        DeploymentConfiguration deploymentConfiguration = service.getDeploymentConfiguration();
        String hillaVersion = HillaStats.getHillaVersion();
        HillaStats.reportHasReactAndLit(deploymentConfiguration, hillaVersion);
        HillaStats.reportHasRouter(service, hasHillaFsRoute, hillaVersion);
    }

    public static void reportHasEndpoint() {
        try {
            UsageStatistics.markAsUsed((String)HAS_ENDPOINT, (String)HillaStats.getHillaVersion());
        }
        catch (Throwable e) {
            LOGGER.debug("Failed to report Hilla statistics", e);
        }
    }

    public static void reportEndpointActive() {
        try {
            UsageStatistics.markAsUsed((String)ENDPOINT_ACTIVE, (String)HillaStats.getHillaVersion());
        }
        catch (Throwable e) {
            LOGGER.debug("Failed to report Hilla statistics", e);
        }
    }
}

