/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.signals.internal;

import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.signals.Id;
import com.vaadin.flow.signals.SignalCommand;
import com.vaadin.flow.signals.shared.AbstractSignal;
import com.vaadin.flow.signals.shared.SignalUtils;
import com.vaadin.flow.signals.shared.impl.CommandResult;
import com.vaadin.flow.signals.shared.impl.SignalTree;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Sinks;
import tools.jackson.core.JacksonException;
import tools.jackson.core.TreeNode;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.node.ObjectNode;

public class InternalSignal {
    private final Map<String, Sinks.Many<JsonNode>> subscribers = new HashMap<String, Sinks.Many<JsonNode>>();
    private final AbstractSignal<?> signal;
    private final SignalTree tree;
    private Registration treeSubscriptionCanceler;
    private final Map<Id, ObjectNode> inProgressCommands = new HashMap<Id, ObjectNode>();
    private final Map<Id, String> commandsOfSubscribers = new HashMap<Id, String>();
    private final ObjectMapper objectMapper;

    public InternalSignal(AbstractSignal<?> signal, ObjectMapper objectMapper) {
        this.signal = signal;
        this.tree = SignalUtils.treeOf(signal);
        this.objectMapper = objectMapper;
    }

    public Id id() {
        return this.tree.id();
    }

    public Flux<JsonNode> subscribe(String clientSignalId) {
        Sinks.Many sink = Sinks.many().unicast().onBackpressureBuffer();
        return sink.asFlux().doOnSubscribe(ignore -> {
            this.tree.getLock().lock();
            try {
                this.getLogger().debug("New Flux subscription...");
                this.subscribers.put(clientSignalId, (Sinks.Many<JsonNode>)sink);
                if (this.treeSubscriptionCanceler == null) {
                    this.treeSubscriptionCanceler = this.tree.subscribeToProcessed(this::notifySubscribers);
                }
                SignalCommand.SnapshotCommand setCommand = new SignalCommand.SnapshotCommand(Id.random(), SignalUtils.treeOf(this.signal).confirmed().nodes());
                sink.tryEmitNext((Object)this.objectMapper.valueToTree((Object)setCommand));
            }
            finally {
                this.tree.getLock().unlock();
            }
        }).doFinally(ignore -> {
            this.tree.getLock().lock();
            try {
                this.getLogger().debug("Unsubscribing from Signal...");
                this.subscribers.remove(clientSignalId);
                if (this.subscribers.isEmpty()) {
                    this.getLogger().debug("No more subscribers, canceling tree subscription");
                    assert (this.treeSubscriptionCanceler != null);
                    this.treeSubscriptionCanceler.remove();
                    this.treeSubscriptionCanceler = null;
                }
            }
            finally {
                this.tree.getLock().unlock();
            }
        });
    }

    private void notifySubscribers(SignalCommand processedCommand, CommandResult result) {
        ObjectNode commandToEmit = this.inProgressCommands.remove(processedCommand.commandId());
        if (result.accepted()) {
            this.subscribers.entrySet().removeIf(client -> this.tryEmitCommandToSubscriber(commandToEmit, (String)client.getKey(), (Sinks.Many<JsonNode>)((Sinks.Many)client.getValue())));
        } else {
            String clientSignalId = this.commandsOfSubscribers.get(processedCommand.commandId());
            if (clientSignalId == null) {
                this.getLogger().debug("No client signal id found for command id {}, skipping notification.", (Object)processedCommand.commandId());
                return;
            }
            boolean failure = this.tryEmitCommandToSubscriber(commandToEmit, clientSignalId, this.subscribers.get(clientSignalId));
            if (failure) {
                this.subscribers.remove(clientSignalId);
            }
        }
        this.commandsOfSubscribers.remove(processedCommand.commandId());
    }

    private boolean tryEmitCommandToSubscriber(ObjectNode processedCommand, String clientSignalId, Sinks.Many<JsonNode> clientSink) {
        boolean failure = clientSink.tryEmitNext((Object)processedCommand).isFailure();
        if (failure) {
            this.getLogger().debug("Failed to emit notification to client with signal id {} and command {}", (Object)clientSignalId, (Object)processedCommand.get("commandId"));
        }
        return failure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submit(String clientSignalId, ObjectNode commandJson) {
        this.tree.getLock().lock();
        try {
            SignalCommand command = (SignalCommand)this.objectMapper.treeToValue((TreeNode)commandJson, SignalCommand.class);
            this.inProgressCommands.put(command.commandId(), commandJson);
            this.commandsOfSubscribers.put(command.commandId(), clientSignalId);
            this.tree.commitSingleCommand(command);
        }
        catch (IllegalArgumentException | JacksonException ex) {
            this.getLogger().error("Failed to process command for signal {}: {}", new Object[]{this.signal.getClass().getName(), ex.getMessage(), ex});
        }
        finally {
            this.tree.getLock().unlock();
        }
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(InternalSignal.class);
    }
}

