/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.signals.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vaadin.signals.AbstractSignal;
import com.vaadin.signals.Id;
import com.vaadin.signals.SignalCommand;
import com.vaadin.signals.SignalUtils;
import com.vaadin.signals.impl.CommandResult;
import com.vaadin.signals.impl.SignalTree;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Sinks;

public class InternalSignal {
    private final Map<String, Sinks.Many<JsonNode>> subscribers = new HashMap<String, Sinks.Many<JsonNode>>();
    private final AbstractSignal<?> signal;
    private final SignalTree tree;
    private Runnable treeSubscriptionCanceler;
    private final Map<Id, ObjectNode> inProgressCommands = new HashMap<Id, ObjectNode>();
    private final Map<Id, String> commandsOfSubscribers = new HashMap<Id, String>();
    private final ObjectMapper objectMapper;

    public InternalSignal(AbstractSignal<?> signal, ObjectMapper objectMapper) {
        this.signal = signal;
        this.tree = SignalUtils.treeOf(signal);
        this.objectMapper = objectMapper;
    }

    public Id id() {
        return this.tree.id();
    }

    public Flux<JsonNode> subscribe(String clientSignalId) {
        Sinks.Many sink = Sinks.many().unicast().onBackpressureBuffer();
        return sink.asFlux().doOnSubscribe(ignore -> {
            this.tree.getLock().lock();
            try {
                this.getLogger().debug("New Flux subscription...");
                this.subscribers.put(clientSignalId, (Sinks.Many<JsonNode>)sink);
                if (this.treeSubscriptionCanceler == null) {
                    this.treeSubscriptionCanceler = this.tree.subscribeToProcessed(this::notifySubscribers);
                }
                SignalCommand.SnapshotCommand setCommand = new SignalCommand.SnapshotCommand(Id.random(), SignalUtils.treeOf(this.signal).confirmed().nodes());
                sink.tryEmitNext((Object)this.objectMapper.valueToTree((Object)setCommand));
            }
            finally {
                this.tree.getLock().unlock();
            }
        }).doFinally(ignore -> {
            this.tree.getLock().lock();
            try {
                this.getLogger().debug("Unsubscribing from Signal...");
                this.subscribers.remove(clientSignalId);
                if (this.subscribers.isEmpty()) {
                    this.getLogger().debug("No more subscribers, canceling tree subscription");
                    assert (this.treeSubscriptionCanceler != null);
                    this.treeSubscriptionCanceler.run();
                    this.treeSubscriptionCanceler = null;
                }
            }
            finally {
                this.tree.getLock().unlock();
            }
        });
    }

    private void notifySubscribers(SignalCommand processedCommand, CommandResult result) {
        ObjectNode commandToEmit = this.inProgressCommands.remove(processedCommand.commandId());
        if (result.accepted()) {
            this.subscribers.entrySet().removeIf(client -> this.tryEmitCommandToSubscriber(commandToEmit, (String)client.getKey(), (Sinks.Many<JsonNode>)((Sinks.Many)client.getValue())));
        } else {
            String clientSignalId = this.commandsOfSubscribers.get(processedCommand.commandId());
            if (clientSignalId == null) {
                this.getLogger().debug("No client signal id found for command id {}, skipping notification.", (Object)processedCommand.commandId());
                return;
            }
            boolean failure = this.tryEmitCommandToSubscriber(commandToEmit, clientSignalId, this.subscribers.get(clientSignalId));
            if (failure) {
                this.subscribers.remove(clientSignalId);
            }
        }
        this.commandsOfSubscribers.remove(processedCommand.commandId());
    }

    private boolean tryEmitCommandToSubscriber(ObjectNode processedCommand, String clientSignalId, Sinks.Many<JsonNode> clientSink) {
        boolean failure = clientSink.tryEmitNext((Object)processedCommand).isFailure();
        if (failure) {
            this.getLogger().debug("Failed to emit notification to client with signal id {} and command {}", (Object)clientSignalId, (Object)processedCommand.get("commandId"));
        }
        return failure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submit(String clientSignalId, ObjectNode commandJson) {
        this.tree.getLock().lock();
        try {
            SignalCommand command = (SignalCommand)this.objectMapper.treeToValue((TreeNode)commandJson, SignalCommand.class);
            this.inProgressCommands.put(command.commandId(), commandJson);
            this.commandsOfSubscribers.put(command.commandId(), clientSignalId);
            this.tree.commitSingleCommand(command);
        }
        catch (JsonProcessingException | IllegalArgumentException ex) {
            this.getLogger().error("Failed to process command for signal {}: {}", new Object[]{this.signal.getClass().getName(), ex.getMessage(), ex});
        }
        finally {
            this.tree.getLock().unlock();
        }
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(InternalSignal.class);
    }
}

