/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.signals.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.vaadin.hilla.ConditionalOnFeatureFlag;
import com.vaadin.hilla.EndpointInvoker;
import com.vaadin.hilla.signals.handler.SignalsHandler;
import com.vaadin.hilla.signals.internal.SecureSignalsRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="signalsConfiguration")
public class SignalsConfiguration {
    private SecureSignalsRegistry signalsRegistry;
    private SignalsHandler signalsHandler;
    private final EndpointInvoker endpointInvoker;
    private final ObjectMapper objectMapper;

    public SignalsConfiguration(EndpointInvoker endpointInvoker, @Qualifier(value="hillaEndpointObjectMapper") ObjectMapper hillaEndpointObjectMapper) {
        this.endpointInvoker = endpointInvoker;
        this.objectMapper = hillaEndpointObjectMapper;
    }

    @ConditionalOnFeatureFlag(value="fullstackSignals")
    @Bean
    public SecureSignalsRegistry signalsRegistry() {
        if (this.signalsRegistry == null) {
            this.signalsRegistry = new SecureSignalsRegistry(this.endpointInvoker, this.objectMapper);
        }
        return this.signalsRegistry;
    }

    @Bean(name={"hillaSignalsHandler"})
    public SignalsHandler signalsHandler(@Autowired(required=false) SecureSignalsRegistry signalsRegistry) {
        if (this.signalsHandler == null) {
            this.signalsHandler = new SignalsHandler(signalsRegistry);
        }
        return this.signalsHandler;
    }
}

