/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.exception;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class EndpointException
extends RuntimeException {
    public static final String ERROR_MESSAGE_FIELD = "message";
    private final transient Object detail;

    public EndpointException(String message) {
        super(message);
        this.detail = null;
    }

    public EndpointException(Throwable cause) {
        super(cause);
        this.detail = null;
    }

    public EndpointException(String message, Object detail) {
        super(message);
        this.detail = detail;
    }

    public EndpointException(String message, Throwable cause) {
        super(message, cause);
        this.detail = null;
    }

    public EndpointException(String message, Throwable cause, Object detail) {
        super(message, cause);
        this.detail = detail;
    }

    public Object getDetail() {
        return this.detail;
    }

    public Map<String, Object> getSerializationData() {
        HashMap<String, Object> serializationData = new HashMap<String, Object>();
        serializationData.put("type", Optional.ofNullable(this.getCause()).orElse(this).getClass().getName());
        String message = this.getMessage();
        if (message != null && !message.isEmpty()) {
            serializationData.put(ERROR_MESSAGE_FIELD, this.getMessage());
        } else {
            Optional.ofNullable(this.getCause()).map(Throwable::getMessage).filter(text -> !text.isEmpty()).ifPresent(originalMessage -> serializationData.put(ERROR_MESSAGE_FIELD, originalMessage));
        }
        if (this.detail != null) {
            serializationData.put("detail", this.detail);
        }
        return serializationData;
    }
}

