/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.crud.filter;

import com.vaadin.hilla.crud.filter.AndFilter;
import com.vaadin.hilla.crud.filter.Filter;
import com.vaadin.hilla.crud.filter.OrFilter;
import com.vaadin.hilla.crud.filter.PropertyStringFilter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class FilterTransformer {
    private final Map<String, String> mappings = new HashMap<String, String>();
    private Function<PropertyStringFilter, PropertyStringFilter> filterTransformation;

    public FilterTransformer withMapping(String from, String to) {
        this.mappings.put(from, to);
        return this;
    }

    public FilterTransformer withFilterTransformation(Function<PropertyStringFilter, PropertyStringFilter> filterTransformation) {
        this.filterTransformation = filterTransformation;
        return this;
    }

    public Filter apply(Filter filter) {
        if (filter == null) {
            return null;
        }
        if (filter instanceof AndFilter) {
            AndFilter andFilter = (AndFilter)filter;
            Filter[] childFilters = (Filter[])andFilter.getChildren().stream().map(this::apply).toArray(Filter[]::new);
            return new AndFilter(childFilters);
        }
        if (filter instanceof OrFilter) {
            OrFilter orFilter = (OrFilter)filter;
            Filter[] childFilters = (Filter[])orFilter.getChildren().stream().map(this::apply).toArray(Filter[]::new);
            return new OrFilter(childFilters);
        }
        if (filter instanceof PropertyStringFilter) {
            PropertyStringFilter propertyStringFilter = (PropertyStringFilter)filter;
            String property = propertyStringFilter.getPropertyId();
            String mappedProperty = this.mappings.get(property);
            String filterProperty = mappedProperty == null ? property : mappedProperty;
            PropertyStringFilter newFilter = new PropertyStringFilter(filterProperty, propertyStringFilter.getMatcher(), propertyStringFilter.getFilterValue());
            if (this.filterTransformation != null) {
                newFilter = this.filterTransformation.apply(newFilter);
            }
            return newFilter;
        }
        return filter;
    }

    public Pageable apply(Pageable pageable) {
        if (pageable == null) {
            return null;
        }
        List<Sort.Order> orders = pageable.getSort().stream().map(order -> {
            String mappedProperty = this.mappings.get(order.getProperty());
            return mappedProperty == null ? order : new Sort.Order(order.getDirection(), mappedProperty);
        }).toList();
        return PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)Sort.by(orders));
    }
}

