/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.dau.DAUUtils;
import com.vaadin.flow.server.dau.EnforcementNotificationMessages;
import com.vaadin.hilla.BrowserCallable;
import com.vaadin.hilla.Endpoint;
import com.vaadin.hilla.EndpointControllerConfiguration;
import com.vaadin.hilla.EndpointInvocationException;
import com.vaadin.hilla.EndpointInvoker;
import com.vaadin.hilla.EndpointProperties;
import com.vaadin.hilla.EndpointRegistry;
import com.vaadin.hilla.HillaStats;
import com.vaadin.hilla.auth.CsrfChecker;
import com.vaadin.hilla.exception.EndpointException;
import com.vaadin.hilla.signals.handler.SignalsHandler;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@Import(value={EndpointControllerConfiguration.class, EndpointProperties.class})
public class EndpointController {
    private static final Logger LOGGER = LoggerFactory.getLogger(EndpointController.class);
    public static final String BODY_PART_NAME = "hilla_body_part";
    static final String ENDPOINT_METHODS = "/{endpoint}/{method}";
    public static final String ENDPOINT_MAPPER_FACTORY_BEAN_QUALIFIER = "endpointMapperFactory";
    private static final Set<Class<?>> INTERNAL_BROWSER_CALLABLES = Set.of(SignalsHandler.class);
    private final ApplicationContext context;
    EndpointRegistry endpointRegistry;
    private final CsrfChecker csrfChecker;
    private final EndpointInvoker endpointInvoker;
    private final ObjectMapper objectMapper;
    VaadinService vaadinService;

    public EndpointController(ApplicationContext context, EndpointRegistry endpointRegistry, EndpointInvoker endpointInvoker, CsrfChecker csrfChecker, @Qualifier(value="hillaEndpointObjectMapper") ObjectMapper objectMapper) {
        this.context = context;
        this.endpointInvoker = endpointInvoker;
        this.csrfChecker = csrfChecker;
        this.endpointRegistry = endpointRegistry;
        this.objectMapper = objectMapper;
    }

    public void registerEndpoints() {
        TreeMap endpointBeans = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        endpointBeans.putAll(this.context.getBeansWithAnnotation(Endpoint.class));
        endpointBeans.putAll(this.context.getBeansWithAnnotation(BrowserCallable.class));
        if (!endpointBeans.isEmpty()) {
            HillaStats.reportHasEndpoint();
        }
        INTERNAL_BROWSER_CALLABLES.stream().map(arg_0 -> ((ApplicationContext)this.context).getBeansOfType(arg_0)).forEach(endpointBeans::putAll);
        Set currentEndpointNames = endpointBeans.values().stream().map(this.endpointRegistry::registerEndpoint).collect(Collectors.toSet());
        this.endpointRegistry.getEndpoints().keySet().retainAll(currentEndpointNames);
        VaadinService vaadinService = VaadinService.getCurrent();
        if (vaadinService != null) {
            this.vaadinService = vaadinService;
        }
    }

    @PostMapping(path={"/{endpoint}/{method}"}, consumes={"application/json"}, produces={"application/json"})
    public ResponseEntity<String> serveEndpoint(@PathVariable(value="endpoint") String endpointName, @PathVariable(value="method") String methodName, @RequestBody(required=false) ObjectNode body, HttpServletRequest request, HttpServletResponse response) {
        return this.doServeEndpoint(endpointName, methodName, body, request, response);
    }

    @PostMapping(path={"/{endpoint}/{method}"}, consumes={"multipart/form-data"}, produces={"application/json"})
    public ResponseEntity<String> serveMultipartEndpoint(@PathVariable(value="endpoint") String endpointName, @PathVariable(value="method") String methodName, HttpServletRequest request, HttpServletResponse response) throws IOException {
        return this.doServeEndpoint(endpointName, methodName, null, request, response);
    }

    public ResponseEntity<String> serveEndpoint(String endpointName, String methodName, ObjectNode body, HttpServletRequest request) {
        return this.doServeEndpoint(endpointName, methodName, body, request, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseEntity<String> doServeEndpoint(String endpointName, String methodName, ObjectNode body, HttpServletRequest request, HttpServletResponse response) {
        LOGGER.debug("Endpoint: {}, method: {}, request body: {}", new Object[]{endpointName, methodName, body});
        if (!this.csrfChecker.validateCsrfTokenInRequest(request)) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)this.endpointInvoker.createResponseErrorObject("Access denied"));
        }
        DAUUtils.EnforcementResult enforcementResult = null;
        try {
            String bodyPart;
            enforcementResult = DAUUtils.trackDAU((VaadinService)this.vaadinService, (HttpServletRequest)request, (HttpServletResponse)response);
            if (enforcementResult.isEnforcementNeeded()) {
                ResponseEntity<String> responseEntity = this.buildEnforcementResponseEntity(enforcementResult);
                return responseEntity;
            }
            if (this.isMultipartRequest(request)) {
                MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
                bodyPart = multipartRequest.getParameter(BODY_PART_NAME);
                if (bodyPart == null) {
                    ResponseEntity responseEntity = ResponseEntity.badRequest().body((Object)this.endpointInvoker.createResponseErrorObject("Missing body part in multipart request"));
                    return responseEntity;
                }
                try {
                    body = (ObjectNode)this.objectMapper.readValue(bodyPart, ObjectNode.class);
                }
                catch (IOException e) {
                    LOGGER.error("Request body does not contain valid JSON", (Throwable)e);
                    ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)this.endpointInvoker.createResponseErrorObject("Request body does not contain valid JSON"));
                    if (enforcementResult != null && enforcementResult.endRequestAction() != null) {
                        enforcementResult.endRequestAction().run();
                    } else {
                        CurrentInstance.set(VaadinRequest.class, null);
                    }
                    return responseEntity;
                }
                Map fileMap = multipartRequest.getFileMap();
                for (Map.Entry entry : fileMap.entrySet()) {
                    String partName = (String)entry.getKey();
                    MultipartFile file = (MultipartFile)entry.getValue();
                    JsonPointer pointer = JsonPointer.valueOf((String)partName);
                    JsonPointer parent = pointer.head();
                    String property = pointer.last().getMatchingProperty();
                    ObjectNode parentObject = body.withObject(parent);
                    parentObject.putPOJO(property, (Object)file);
                }
            }
            Object returnValue = this.endpointInvoker.invoke(endpointName, methodName, body, request.getUserPrincipal(), arg_0 -> ((HttpServletRequest)request).isUserInRole(arg_0));
            try {
                bodyPart = ResponseEntity.ok((Object)this.endpointInvoker.writeValueAsString(returnValue));
                return bodyPart;
            }
            catch (JsonProcessingException e32) {
                Object object;
                String errorMessage;
                try {
                    errorMessage = String.format("Failed to serialize endpoint '%s' method '%s' response. Double check method's return type or specify a custom mapper bean with qualifier '%s'", endpointName, methodName, ENDPOINT_MAPPER_FACTORY_BEAN_QUALIFIER);
                    LOGGER.error(errorMessage, (Throwable)e32);
                    throw new EndpointInvocationException.EndpointInternalException(errorMessage);
                }
                catch (EndpointException e2) {
                    try {
                        ResponseEntity e32 = ResponseEntity.badRequest().body((Object)this.endpointInvoker.createResponseErrorObject(e2.getSerializationData()));
                        return e32;
                    }
                    catch (JsonProcessingException ee) {
                        errorMessage = "Failed to serialize error object for endpoint exception. ";
                        LOGGER.error(errorMessage, (Throwable)e2);
                        object = ResponseEntity.internalServerError().body((Object)errorMessage);
                        return object;
                    }
                }
                catch (EndpointInvocationException.EndpointHttpException e4) {
                    ResponseEntity.BodyBuilder resp = ResponseEntity.status((int)e4.getHttpStatusCode());
                    String message = e4.getMessage();
                    object = message == null ? resp.build() : resp.body((Object)this.endpointInvoker.createResponseErrorObject(message));
                    return object;
                }
            }
        }
        finally {
            if (enforcementResult != null && enforcementResult.endRequestAction() != null) {
                enforcementResult.endRequestAction().run();
            } else {
                CurrentInstance.set(VaadinRequest.class, null);
            }
        }
    }

    private boolean isMultipartRequest(HttpServletRequest request) {
        String contentType = request.getContentType();
        return contentType != null && contentType.startsWith("multipart/form-data");
    }

    private ResponseEntity<String> buildEnforcementResponseEntity(DAUUtils.EnforcementResult enforcementResult) {
        EnforcementNotificationMessages messages = enforcementResult.messages();
        EndpointException endpointException = new EndpointException(messages.caption(), enforcementResult.origin(), messages);
        try {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE).body((Object)this.endpointInvoker.createResponseErrorObject(endpointException.getSerializationData()));
        }
        catch (JsonProcessingException ee) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE).body((Object)this.endpointInvoker.createResponseErrorObject(messages.caption() + ". " + messages.message()));
        }
    }

    private Object instantiateEndpointByClassName(String className) {
        Class<?> cls;
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn("Endpoint class {} is not available", (Object)className, (Object)e);
            return null;
        }
        try {
            Object endpoint = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            LOGGER.warn("Endpoint '{}' is not a Spring bean and has been instantiated using default constructor. This is not guaranteed to be supported in future releases.", (Object)className);
            return endpoint;
        }
        catch (ReflectiveOperationException ex) {
            LOGGER.error("Endpoint '{}' is not a Spring bean and cannot be instantiated.", (Object)className);
            return null;
        }
    }
}

