/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class EndpointNameChecker {
    public static final Set<String> ECMA_SCRIPT_RESERVED_WORDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("abstract", "arguments", "await", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "debugger", "default", "delete", "do", "double", "else", "enum", "eval", "export", "extends", "false", "final", "finally", "float", "for", "function", "goto", "if", "implements", "import", "in", "instanceof", "int", "interface", "let", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "typeof", "var", "void", "volatile", "while", "with", "yield")));
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s");

    public String check(String endpointName) {
        if (endpointName == null || endpointName.isEmpty()) {
            return "Endpoint name cannot be blank";
        }
        if (ECMA_SCRIPT_RESERVED_WORDS.contains(endpointName)) {
            return "Endpoint name cannot be equal to JavaScript reserved words";
        }
        if (WHITESPACE_PATTERN.matcher(endpointName).find()) {
            return "Endpoint name cannot contain any whitespaces";
        }
        return null;
    }
}

